/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.metainfo.TorrentId;
import bt.net.ConnectionHandler;
import bt.net.HandshakeHandler;
import bt.net.IConnectionHandlerFactory;
import bt.net.IncomingHandshakeHandler;
import bt.net.OutgoingHandshakeHandler;
import bt.protocol.IHandshakeFactory;
import bt.torrent.TorrentRegistry;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ConnectionHandlerFactory
implements IConnectionHandlerFactory {
    private IHandshakeFactory handshakeFactory;
    private ConnectionHandler incomingHandler;
    private Duration peerHandshakeTimeout;
    private Collection<HandshakeHandler> handshakeHandlers;
    private Map<TorrentId, ConnectionHandler> outgoingHandlers;

    public ConnectionHandlerFactory(IHandshakeFactory handshakeFactory, TorrentRegistry torrentRegistry, Collection<HandshakeHandler> handshakeHandlers, Duration peerHandshakeTimeout) {
        this.handshakeFactory = handshakeFactory;
        this.incomingHandler = new IncomingHandshakeHandler(handshakeFactory, torrentRegistry, handshakeHandlers, peerHandshakeTimeout);
        this.outgoingHandlers = new ConcurrentHashMap<TorrentId, ConnectionHandler>();
        this.handshakeHandlers = handshakeHandlers;
        this.peerHandshakeTimeout = peerHandshakeTimeout;
    }

    @Override
    public ConnectionHandler getIncomingHandler() {
        return this.incomingHandler;
    }

    @Override
    public ConnectionHandler getOutgoingHandler(TorrentId torrentId) {
        ConnectionHandler existing;
        Objects.requireNonNull(torrentId, "Missing torrent ID");
        ConnectionHandler outgoing = this.outgoingHandlers.get(torrentId);
        if (outgoing == null && (existing = this.outgoingHandlers.putIfAbsent(torrentId, outgoing = new OutgoingHandshakeHandler(this.handshakeFactory, torrentId, this.handshakeHandlers, this.peerHandshakeTimeout.toMillis()))) != null) {
            outgoing = existing;
        }
        return outgoing;
    }
}

