/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.net.PeerConnection;
import java.util.Objects;
import java.util.Optional;

public class ConnectionResult {
    private final PeerConnection connection;
    private final Throwable error;
    private final String message;

    public static ConnectionResult success(PeerConnection connection) {
        Objects.requireNonNull(connection);
        return new ConnectionResult(connection, null, null);
    }

    public static ConnectionResult failure(String message, Throwable error) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(error);
        return new ConnectionResult(null, error, message);
    }

    public static ConnectionResult failure(String message) {
        Objects.requireNonNull(message);
        return new ConnectionResult(null, null, message);
    }

    private ConnectionResult(PeerConnection connection, Throwable error, String message) {
        this.connection = connection;
        this.error = error;
        this.message = message;
    }

    public boolean isSuccess() {
        return this.connection != null;
    }

    public PeerConnection getConnection() {
        if (!this.isSuccess()) {
            throw new IllegalStateException("Attempt to retrieve connection from unsuccessful result");
        }
        return this.connection;
    }

    public Optional<Throwable> getError() {
        if (this.isSuccess()) {
            throw new IllegalStateException("Attempt to retrieve error from successful result");
        }
        return Optional.ofNullable(this.error);
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }
}

