/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.CountingThreadFactory;
import bt.metainfo.TorrentId;
import bt.net.ConnectionResult;
import bt.net.IConnectionSource;
import bt.net.IPeerConnectionFactory;
import bt.net.IPeerConnectionPool;
import bt.net.IncomingConnectionListener;
import bt.net.Peer;
import bt.net.PeerConnection;
import bt.net.PeerConnectionAcceptor;
import bt.runtime.Config;
import bt.service.IRuntimeLifecycleBinder;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionSource
implements IConnectionSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionSource.class);
    private final IPeerConnectionFactory connectionFactory;
    private final IPeerConnectionPool connectionPool;
    private final ExecutorService connectionExecutor;
    private final Config config;
    private final Map<Peer, CompletableFuture<ConnectionResult>> pendingConnections;
    private final ConcurrentMap<Peer, Long> unreachablePeers;

    @Inject
    public ConnectionSource(Set<PeerConnectionAcceptor> connectionAcceptors, IPeerConnectionFactory connectionFactory, IPeerConnectionPool connectionPool, IRuntimeLifecycleBinder lifecycleBinder, Config config) {
        this.connectionFactory = connectionFactory;
        this.connectionPool = connectionPool;
        this.config = config;
        this.connectionExecutor = Executors.newFixedThreadPool(config.getMaxPendingConnectionRequests(), CountingThreadFactory.daemonFactory("bt.net.pool.connection-worker"));
        lifecycleBinder.onShutdown("Shutdown connection workers", this.connectionExecutor::shutdownNow);
        this.pendingConnections = new ConcurrentHashMap<Peer, CompletableFuture<ConnectionResult>>();
        this.unreachablePeers = new ConcurrentHashMap<Peer, Long>();
        IncomingConnectionListener incomingListener = new IncomingConnectionListener(connectionAcceptors, this.connectionExecutor, connectionPool, config);
        lifecycleBinder.onStartup("Initialize incoming connection acceptors", incomingListener::startup);
        lifecycleBinder.onShutdown("Shutdown incoming connection acceptors", incomingListener::shutdown);
    }

    @Override
    public ConnectionResult getConnection(Peer peer, TorrentId torrentId) {
        try {
            return this.getConnectionAsync(peer, torrentId).get();
        }
        catch (InterruptedException e) {
            return ConnectionResult.failure("Interrupted while waiting for connection", e);
        }
        catch (ExecutionException e) {
            return ConnectionResult.failure("Failed to establish connection due to error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<ConnectionResult> getConnectionAsync(Peer peer, TorrentId torrentId) {
        CompletionStage<ConnectionResult> connection = this.getExistingOrPendingConnection(peer);
        if (connection != null) {
            if (connection.isDone() && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Returning existing connection for peer: {}. Torrent: {}", (Object)peer, (Object)torrentId);
            }
            return connection;
        }
        Long bannedAt = (Long)this.unreachablePeers.get(peer);
        if (bannedAt != null) {
            if (System.currentTimeMillis() - bannedAt >= this.config.getUnreachablePeerBanDuration().toMillis()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Removing temporary ban for unreachable peer: {}", (Object)peer);
                }
                this.unreachablePeers.remove(peer);
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Will not attempt to establish connection to peer: {}. Reason: peer is unreachable. Torrent: {}", (Object)peer, (Object)torrentId);
                }
                return CompletableFuture.completedFuture(ConnectionResult.failure("Peer is unreachable"));
            }
        }
        if (this.connectionPool.size() >= this.config.getMaxPeerConnections()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Will not attempt to establish connection to peer: {}. Reason: connections limit exceeded. Torrent: {}", (Object)peer, (Object)torrentId);
            }
            return CompletableFuture.completedFuture(ConnectionResult.failure("Connections limit exceeded"));
        }
        Map<Peer, CompletableFuture<ConnectionResult>> map = this.pendingConnections;
        synchronized (map) {
            connection = this.getExistingOrPendingConnection(peer);
            if (connection != null) {
                if (connection.isDone() && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Returning existing connection for peer: {}. Torrent: {}", (Object)peer, (Object)torrentId);
                }
                return connection;
            }
            connection = CompletableFuture.supplyAsync(() -> {
                try {
                    ConnectionResult connectionResult = this.connectionFactory.createOutgoingConnection(peer, torrentId);
                    if (connectionResult.isSuccess()) {
                        PeerConnection established = connectionResult.getConnection();
                        PeerConnection added = this.connectionPool.addConnectionIfAbsent(established);
                        if (added != established) {
                            established.closeQuietly();
                        }
                        ConnectionResult connectionResult2 = ConnectionResult.success(added);
                        return connectionResult2;
                    }
                    ConnectionResult connectionResult3 = connectionResult;
                    return connectionResult3;
                }
                finally {
                    Map<Peer, CompletableFuture<ConnectionResult>> map = this.pendingConnections;
                    synchronized (map) {
                        this.pendingConnections.remove(peer);
                    }
                }
            }, this.connectionExecutor).whenComplete((acquiredConnection, throwable) -> {
                if (acquiredConnection == null || throwable != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Peer is unreachable: {}. Will prevent further attempts to establish connection.", (Object)peer);
                    }
                    this.unreachablePeers.putIfAbsent(peer, System.currentTimeMillis());
                }
                if (throwable != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to establish outgoing connection to peer: " + peer, throwable);
                }
            });
            this.pendingConnections.put(peer, (CompletableFuture<ConnectionResult>)connection);
            return connection;
        }
    }

    private CompletableFuture<ConnectionResult> getExistingOrPendingConnection(Peer peer) {
        PeerConnection existingConnection = this.connectionPool.getConnection(peer);
        if (existingConnection != null) {
            return CompletableFuture.completedFuture(ConnectionResult.success(existingConnection));
        }
        CompletableFuture<ConnectionResult> pendingConnection = this.pendingConnections.get(peer);
        if (pendingConnection != null) {
            return pendingConnection;
        }
        return null;
    }
}

