/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.module.PeerConnectionSelector;
import bt.net.DataReceiver;
import bt.net.SharedSelector;
import bt.net.pipeline.ChannelHandlerContext;
import bt.service.IRuntimeLifecycleBinder;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataReceivingLoop
implements Runnable,
DataReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataReceivingLoop.class);
    private static final int NO_OPS = 0;
    private final SharedSelector selector;
    private volatile boolean shutdown;

    @Inject
    public DataReceivingLoop(@PeerConnectionSelector SharedSelector selector, IRuntimeLifecycleBinder lifecycleBinder) {
        this.selector = selector;
        this.schedule(lifecycleBinder);
    }

    private void schedule(IRuntimeLifecycleBinder lifecycleBinder) {
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "bt.net.data-receiver"));
        lifecycleBinder.onStartup("Initialize message receiver", () -> executor.execute(this::run));
        lifecycleBinder.onShutdown("Shutdown message receiver", () -> {
            try {
                this.shutdown();
            }
            finally {
                executor.shutdownNow();
            }
        });
    }

    @Override
    public void registerChannel(SelectableChannel channel, ChannelHandlerContext context) {
        this.selector.wakeupAndRegister(channel, 1, context);
    }

    @Override
    public void unregisterChannel(SelectableChannel channel) {
        this.selector.keyFor(channel).ifPresent(SelectionKey::cancel);
    }

    @Override
    public void activateChannel(SelectableChannel channel) {
        this.updateInterestOps(channel, 1);
    }

    @Override
    public void deactivateChannel(SelectableChannel channel) {
        this.updateInterestOps(channel, 0);
    }

    private void updateInterestOps(SelectableChannel channel, int interestOps) {
        this.selector.keyFor(channel).ifPresent(key -> {
            SelectionKey selectionKey = key;
            synchronized (selectionKey) {
                key.interestOps(interestOps);
            }
        });
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            if (!this.selector.isOpen()) {
                LOGGER.info("Selector is closed, stopping...");
                break;
            }
            try {
                long t1 = System.nanoTime();
                long timeToBlockMillis = 1000L;
                while (this.selector.select(timeToBlockMillis) == 0) {
                    Thread.yield();
                    long t2 = System.nanoTime();
                    if (t2 - t1 < timeToBlockMillis * 1000L || this.selector.selectedKeys().isEmpty()) continue;
                    break;
                }
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (selectedKeys.hasNext()) {
                    try {
                        if (!this.processKey(selectedKeys.next())) continue;
                        selectedKeys.remove();
                    }
                    catch (ClosedSelectorException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to process key", (Throwable)e);
                        selectedKeys.remove();
                    }
                }
            }
            catch (ClosedSelectorException e) {
                LOGGER.info("Selector has been closed, will stop receiving messages...");
                return;
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected I/O exception when selecting peer connections", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processKey(SelectionKey key) {
        ChannelHandlerContext handler;
        SelectionKey selectionKey = key;
        synchronized (selectionKey) {
            handler = this.getHandlerContext(key);
            if (!key.isValid() || !key.isReadable()) {
                return false;
            }
        }
        handler.fireChannelReady();
        return true;
    }

    private ChannelHandlerContext getHandlerContext(SelectionKey key) {
        Object obj = key.attachment();
        if (obj == null || !(obj instanceof ChannelHandlerContext)) {
            throw new RuntimeException("Unexpected attachment in selection key: " + obj);
        }
        return (ChannelHandlerContext)obj;
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

