/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.CountingThreadFactory;
import bt.net.ConnectionResult;
import bt.net.ConnectionRoutine;
import bt.net.IPeerConnectionPool;
import bt.net.PeerConnectionAcceptor;
import bt.runtime.Config;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingConnectionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomingConnectionListener.class);
    private final Set<PeerConnectionAcceptor> connectionAcceptors;
    private final ExecutorService connectionExecutor;
    private final IPeerConnectionPool connectionPool;
    private final Config config;
    private final ExecutorService executor;
    private volatile boolean shutdown;

    public IncomingConnectionListener(Set<PeerConnectionAcceptor> connectionAcceptors, ExecutorService connectionExecutor, IPeerConnectionPool connectionPool, Config config) {
        this.connectionAcceptors = connectionAcceptors;
        this.connectionExecutor = connectionExecutor;
        this.connectionPool = connectionPool;
        this.config = config;
        this.executor = Executors.newFixedThreadPool(connectionAcceptors.size(), CountingThreadFactory.factory("bt.net.pool.incoming-acceptor"));
    }

    public void startup() {
        this.connectionAcceptors.forEach(acceptor -> this.executor.submit(() -> {
            while (!this.shutdown) {
                ConnectionRoutine connectionRoutine;
                try {
                    connectionRoutine = acceptor.accept();
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error", (Throwable)e);
                    return;
                }
                if (this.mightAddConnection()) {
                    this.establishConnection(connectionRoutine);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Rejecting incoming connection from {} due to exceeding of connections limit", (Object)connectionRoutine.getRemoteAddress());
                }
                connectionRoutine.cancel();
            }
        }));
    }

    private void establishConnection(ConnectionRoutine connectionRoutine) {
        this.connectionExecutor.submit(() -> {
            ConnectionResult connectionResult;
            boolean added = false;
            if (!this.shutdown && (connectionResult = connectionRoutine.establish()).isSuccess() && !this.shutdown && this.mightAddConnection()) {
                this.connectionPool.addConnectionIfAbsent(connectionResult.getConnection());
                added = true;
            }
            if (!added) {
                connectionRoutine.cancel();
            }
        });
    }

    private boolean mightAddConnection() {
        return this.connectionPool.size() < this.config.getMaxPeerConnections();
    }

    public void shutdown() {
        this.shutdown = true;
        this.executor.shutdownNow();
    }
}

