/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.metainfo.TorrentId;
import bt.net.ConnectionHandler;
import bt.net.HandshakeHandler;
import bt.net.Peer;
import bt.net.PeerConnection;
import bt.net.WriteOnlyPeerConnection;
import bt.protocol.Handshake;
import bt.protocol.IHandshakeFactory;
import bt.protocol.Message;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentRegistry;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IncomingHandshakeHandler
implements ConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncomingHandshakeHandler.class);
    private IHandshakeFactory handshakeFactory;
    private TorrentRegistry torrentRegistry;
    private Collection<HandshakeHandler> handshakeHandlers;
    private Duration handshakeTimeout;

    public IncomingHandshakeHandler(IHandshakeFactory handshakeFactory, TorrentRegistry torrentRegistry, Collection<HandshakeHandler> handshakeHandlers, Duration handshakeTimeout) {
        this.handshakeFactory = handshakeFactory;
        this.torrentRegistry = torrentRegistry;
        this.handshakeHandlers = handshakeHandlers;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public boolean handleConnection(PeerConnection connection) {
        Message firstMessage;
        Peer peer;
        block9: {
            peer = connection.getRemotePeer();
            firstMessage = null;
            try {
                firstMessage = connection.readMessage(this.handshakeTimeout.toMillis());
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block9;
                LOGGER.debug("Failed to receive handshake from peer: {}. Reason: {} ({})", new Object[]{peer, e.getClass().getName(), e.getMessage()});
            }
        }
        if (firstMessage != null) {
            if (Handshake.class.equals(firstMessage.getClass())) {
                Handshake peerHandshake = (Handshake)firstMessage;
                TorrentId torrentId = peerHandshake.getTorrentId();
                Optional<TorrentDescriptor> descriptorOptional = this.torrentRegistry.getDescriptor(torrentId);
                if (this.torrentRegistry.getTorrentIds().contains(torrentId) && (!descriptorOptional.isPresent() || descriptorOptional.get().isActive())) {
                    Handshake handshake = this.handshakeFactory.createHandshake(torrentId);
                    this.handshakeHandlers.forEach(handler -> handler.processOutgoingHandshake(handshake));
                    try {
                        connection.postMessage(handshake);
                    }
                    catch (IOException e) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Failed to send handshake to peer: {}. Reason: {} ({})", new Object[]{peer, e.getClass().getName(), e.getMessage()});
                        }
                        return false;
                    }
                    connection.setTorrentId(torrentId);
                    this.handshakeHandlers.forEach(handler -> handler.processIncomingHandshake(new WriteOnlyPeerConnection(connection), peerHandshake));
                    return true;
                }
            } else {
                LOGGER.warn("Received message of unexpected type '{}' instead of handshake from peer: {}", firstMessage.getClass(), (Object)peer);
            }
        }
        return false;
    }
}

