/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.net.InetPeerAddress;
import bt.net.Peer;
import bt.net.PeerId;
import bt.peer.PeerOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.function.Supplier;

public class InetPeer
implements Peer {
    private Supplier<InetSocketAddress> addressSupplier;
    private Optional<PeerId> peerId;
    private final PeerOptions options;

    public InetPeer(InetAddress inetAddress, int port) {
        this(inetAddress, port, null, PeerOptions.defaultOptions());
    }

    public InetPeer(InetSocketAddress address) {
        this(() -> address, null, PeerOptions.defaultOptions());
    }

    public InetPeer(InetPeerAddress addressHolder) {
        this(addressHolder::getAddress, null, PeerOptions.defaultOptions());
    }

    public InetPeer(InetAddress inetAddress, int port, PeerOptions options) {
        this(inetAddress, port, null, options);
    }

    public InetPeer(InetSocketAddress address, PeerOptions options) {
        this(() -> address, null, options);
    }

    public InetPeer(InetPeerAddress addressHolder, PeerOptions options) {
        this(addressHolder::getAddress, null, options);
    }

    public InetPeer(InetAddress inetAddress, int port, PeerId peerId) {
        this(inetAddress, port, peerId, PeerOptions.defaultOptions());
    }

    public InetPeer(InetSocketAddress address, PeerId peerId) {
        this(() -> address, peerId, PeerOptions.defaultOptions());
    }

    public InetPeer(InetPeerAddress addressHolder, PeerId peerId) {
        this(addressHolder::getAddress, peerId, PeerOptions.defaultOptions());
    }

    public InetPeer(InetAddress inetAddress, int port, PeerId peerId, PeerOptions options) {
        this(() -> InetPeer.createAddress(inetAddress, port), peerId, options);
    }

    public InetPeer(InetSocketAddress address, PeerId peerId, PeerOptions options) {
        this(() -> address, peerId, options);
    }

    public InetPeer(InetPeerAddress addressHolder, PeerId peerId, PeerOptions options) {
        this(addressHolder::getAddress, peerId, options);
    }

    private InetPeer(Supplier<InetSocketAddress> addressSupplier, PeerId peerId, PeerOptions options) {
        this.addressSupplier = addressSupplier;
        this.peerId = Optional.ofNullable(peerId);
        this.options = options;
    }

    private static InetSocketAddress createAddress(InetAddress inetAddress, int port) {
        if (inetAddress == null || port < 0) {
            throw new IllegalArgumentException("Invalid arguments (address: <" + inetAddress + ":" + port + ">)");
        }
        return new InetSocketAddress(inetAddress, port);
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return this.addressSupplier.get();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.addressSupplier.get().getAddress();
    }

    @Override
    public int getPort() {
        return this.addressSupplier.get().getPort();
    }

    @Override
    public Optional<PeerId> getPeerId() {
        return this.peerId;
    }

    @Override
    public PeerOptions getOptions() {
        return this.options;
    }

    public int hashCode() {
        return this.addressSupplier.get().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !Peer.class.isAssignableFrom(object.getClass())) {
            return false;
        }
        Peer that = (Peer)object;
        return this.addressSupplier.get().equals(that.getInetSocketAddress());
    }

    public String toString() {
        return this.addressSupplier.get().toString();
    }
}

