/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import java.net.InetSocketAddress;
import java.util.Objects;

public class InetPeerAddress {
    private final String hostname;
    private final int port;
    private final int hashCode;
    private volatile InetSocketAddress address;
    private final Object lock;

    public InetPeerAddress(String hostname, int port) {
        this.hostname = Objects.requireNonNull(hostname);
        this.port = port;
        this.hashCode = 31 * hostname.hashCode() + port;
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetSocketAddress getAddress() {
        if (this.address == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.address == null) {
                    this.address = new InetSocketAddress(this.hostname, this.port);
                }
            }
        }
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        InetPeerAddress that = (InetPeerAddress)object;
        return this.port == that.port && this.hostname.equals(that.hostname);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

