/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;

public class InternetProtocolUtils {
    private static final int IP4_BYTES = 4;
    private static final int IP6_BYTES = 16;

    public static ProtocolFamily getProtocolFamily(InetAddress address) {
        if (address.getAddress().length == 4) {
            return StandardProtocolFamily.INET;
        }
        if (address.getAddress().length == 16) {
            return StandardProtocolFamily.INET6;
        }
        throw new IllegalArgumentException("Can't determine protocol family for address: " + address);
    }

    public static boolean isIP4(InetSocketAddress address) {
        return InternetProtocolUtils.getProtocolFamily(address.getAddress()) == StandardProtocolFamily.INET;
    }

    public static boolean isIP6(InetSocketAddress address) {
        return InternetProtocolUtils.getProtocolFamily(address.getAddress()) == StandardProtocolFamily.INET6;
    }

    public static String getLiteralIP(InetAddress address) {
        String s = address.toString();
        int k = s.indexOf(47);
        if (k >= 0) {
            s = s.substring(k + 1);
        }
        return s;
    }
}

