/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.metainfo.TorrentId;
import bt.net.ConnectionHandler;
import bt.net.HandshakeHandler;
import bt.net.Peer;
import bt.net.PeerConnection;
import bt.net.WriteOnlyPeerConnection;
import bt.protocol.Handshake;
import bt.protocol.IHandshakeFactory;
import bt.protocol.Message;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OutgoingHandshakeHandler
implements ConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutgoingHandshakeHandler.class);
    private IHandshakeFactory handshakeFactory;
    private TorrentId torrentId;
    private Collection<HandshakeHandler> handshakeHandlers;
    private long handshakeTimeout;

    public OutgoingHandshakeHandler(IHandshakeFactory handshakeFactory, TorrentId torrentId, Collection<HandshakeHandler> handshakeHandlers, long handshakeTimeout) {
        this.handshakeFactory = handshakeFactory;
        this.torrentId = torrentId;
        this.handshakeHandlers = handshakeHandlers;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public boolean handleConnection(PeerConnection connection) {
        Message firstMessage;
        Peer peer;
        block9: {
            peer = connection.getRemotePeer();
            Handshake handshake = this.handshakeFactory.createHandshake(this.torrentId);
            this.handshakeHandlers.forEach(handler -> handler.processOutgoingHandshake(handshake));
            try {
                connection.postMessage(handshake);
            }
            catch (IOException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to send handshake to peer: {}. Reason: {} ({})", new Object[]{peer, e.getClass().getName(), e.getMessage()});
                }
                return false;
            }
            firstMessage = null;
            try {
                firstMessage = connection.readMessage(this.handshakeTimeout);
            }
            catch (IOException e) {
                if (!LOGGER.isDebugEnabled()) break block9;
                LOGGER.debug("Failed to receive handshake from peer: {}. Reason: {} ({})", new Object[]{peer, e.getClass().getName(), e.getMessage()});
            }
        }
        if (firstMessage != null) {
            if (Handshake.class.equals(firstMessage.getClass())) {
                Handshake peerHandshake = (Handshake)firstMessage;
                TorrentId incomingTorrentId = peerHandshake.getTorrentId();
                if (this.torrentId.equals(incomingTorrentId)) {
                    connection.setTorrentId(this.torrentId);
                    this.handshakeHandlers.forEach(handler -> handler.processIncomingHandshake(new WriteOnlyPeerConnection(connection), peerHandshake));
                    return true;
                }
            } else {
                LOGGER.warn("Received message of unexpected type '{}' instead of handshake from peer: {}", firstMessage.getClass(), (Object)peer);
            }
        }
        return false;
    }
}

