/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.event.EventSource;
import bt.metainfo.TorrentId;
import bt.net.ConnectionHandler;
import bt.net.ConnectionResult;
import bt.net.DataReceiver;
import bt.net.IConnectionHandlerFactory;
import bt.net.IPeerConnectionFactory;
import bt.net.Peer;
import bt.net.PeerConnection;
import bt.net.SocketPeerConnection;
import bt.net.buffer.BorrowedBuffer;
import bt.net.buffer.BufferMutator;
import bt.net.buffer.IBufferManager;
import bt.net.crypto.CipherBufferMutator;
import bt.net.crypto.MSEHandshakeProcessor;
import bt.net.pipeline.ChannelHandler;
import bt.net.pipeline.ChannelPipeline;
import bt.net.pipeline.ChannelPipelineBuilder;
import bt.net.pipeline.IChannelPipelineFactory;
import bt.net.pipeline.SocketChannelHandler;
import bt.protocol.Message;
import bt.protocol.crypto.MSECipher;
import bt.protocol.handler.MessageHandler;
import bt.runtime.Config;
import bt.torrent.TorrentRegistry;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerConnectionFactory
implements IPeerConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerConnectionFactory.class);
    private static final Duration socketTimeout = Duration.ofSeconds(30L);
    private MessageHandler<Message> protocol;
    private Selector selector;
    private IConnectionHandlerFactory connectionHandlerFactory;
    private IChannelPipelineFactory channelPipelineFactory;
    private IBufferManager bufferManager;
    private MSEHandshakeProcessor cryptoHandshakeProcessor;
    private DataReceiver dataReceiver;
    private EventSource eventSource;
    private InetSocketAddress localOutgoingSocketAddress;

    public PeerConnectionFactory(Selector selector, IConnectionHandlerFactory connectionHandlerFactory, IChannelPipelineFactory channelPipelineFactory, MessageHandler<Message> protocol, TorrentRegistry torrentRegistry, IBufferManager bufferManager, DataReceiver dataReceiver, EventSource eventSource, Config config) {
        this.protocol = protocol;
        this.selector = selector;
        this.connectionHandlerFactory = connectionHandlerFactory;
        this.channelPipelineFactory = channelPipelineFactory;
        this.bufferManager = bufferManager;
        this.cryptoHandshakeProcessor = new MSEHandshakeProcessor(torrentRegistry, protocol, config);
        this.dataReceiver = dataReceiver;
        this.eventSource = eventSource;
        this.localOutgoingSocketAddress = new InetSocketAddress(config.getAcceptorAddress(), 0);
    }

    @Override
    public ConnectionResult createOutgoingConnection(Peer peer, TorrentId torrentId) {
        SocketChannel channel;
        Objects.requireNonNull(peer);
        Objects.requireNonNull(torrentId);
        InetAddress inetAddress = peer.getInetAddress();
        int port = peer.getPort();
        try {
            channel = this.getChannel(inetAddress, port);
        }
        catch (IOException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to establish connection with peer: {}. Reason: {} ({})", new Object[]{peer, e.getClass().getName(), e.getMessage()});
            }
            return ConnectionResult.failure("I/O error", e);
        }
        return this.createConnection(peer, torrentId, channel, false);
    }

    private SocketChannel getChannel(InetAddress inetAddress, int port) throws IOException {
        InetSocketAddress remoteAddress = new InetSocketAddress(inetAddress, port);
        SocketChannel outgoingChannel = this.selector.provider().openSocketChannel();
        outgoingChannel.socket().bind(this.localOutgoingSocketAddress);
        outgoingChannel.socket().setSoTimeout((int)socketTimeout.toMillis());
        outgoingChannel.socket().setSoLinger(false, 0);
        outgoingChannel.connect(remoteAddress);
        return outgoingChannel;
    }

    @Override
    public ConnectionResult createIncomingConnection(Peer peer, SocketChannel channel) {
        return this.createConnection(peer, null, channel, true);
    }

    private ConnectionResult createConnection(Peer peer, TorrentId torrentId, SocketChannel channel, boolean incoming) {
        BorrowedBuffer<ByteBuffer> in = this.bufferManager.borrowByteBuffer();
        BorrowedBuffer<ByteBuffer> out = this.bufferManager.borrowByteBuffer();
        try {
            return this._createConnection(peer, torrentId, channel, incoming, in, out);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to establish connection with peer: {}. Reason: {} ({})", new Object[]{peer, e.getClass().getName(), e.getMessage()});
            }
            this.closeQuietly(channel);
            this.releaseBuffer(in);
            this.releaseBuffer(out);
            return ConnectionResult.failure("Unexpected error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionResult _createConnection(Peer peer, TorrentId torrentId, SocketChannel channel, boolean incoming, BorrowedBuffer<ByteBuffer> in, BorrowedBuffer<ByteBuffer> out) throws IOException {
        Optional<MSECipher> cipherOptional;
        if (!incoming && torrentId == null) {
            throw new IllegalStateException("Requested outgoing connection without torrent ID. Peer: " + peer);
        }
        channel.configureBlocking(false);
        ByteBuffer inBuffer = in.lockAndGet();
        ByteBuffer outBuffer = out.lockAndGet();
        try {
            cipherOptional = incoming ? this.cryptoHandshakeProcessor.negotiateIncoming(peer, channel, inBuffer, outBuffer) : this.cryptoHandshakeProcessor.negotiateOutgoing(peer, channel, torrentId, inBuffer, outBuffer);
        }
        finally {
            in.unlock();
            out.unlock();
        }
        ChannelPipeline pipeline = this.createPipeline(peer, channel, in, out, cipherOptional);
        SocketChannelHandler channelHandler = new SocketChannelHandler(channel, in, out, pipeline::bindHandler, this.dataReceiver);
        channelHandler.register();
        SocketPeerConnection connection = new SocketPeerConnection(peer, channelHandler);
        ConnectionHandler connectionHandler = incoming ? this.connectionHandlerFactory.getIncomingHandler() : this.connectionHandlerFactory.getOutgoingHandler(torrentId);
        boolean inited = this.initConnection(connection, connectionHandler);
        if (inited) {
            this.subscribeHandler(connection.getTorrentId(), channelHandler);
            return ConnectionResult.success(connection);
        }
        connection.closeQuietly();
        return ConnectionResult.failure("Handshake failed");
    }

    private void subscribeHandler(TorrentId torrentId, ChannelHandler channelHandler) {
        this.eventSource.onTorrentStarted(event -> {
            if (event.getTorrentId().equals(torrentId)) {
                channelHandler.activate();
            }
        });
        this.eventSource.onTorrentStopped(event -> {
            if (event.getTorrentId().equals(torrentId)) {
                channelHandler.deactivate();
            }
        });
    }

    private ChannelPipeline createPipeline(Peer peer, ByteChannel channel, BorrowedBuffer<ByteBuffer> in, BorrowedBuffer<ByteBuffer> out, Optional<MSECipher> cipherOptional) {
        ChannelPipelineBuilder builder = this.channelPipelineFactory.buildPipeline(peer);
        builder.channel(channel);
        builder.protocol(this.protocol);
        builder.inboundBuffer(in);
        builder.outboundBuffer(out);
        cipherOptional.ifPresent(cipher -> {
            builder.decoders(new CipherBufferMutator(cipher.getDecryptionCipher()), new BufferMutator[0]);
            builder.encoders(new CipherBufferMutator(cipher.getEncryptionCipher()), new BufferMutator[0]);
        });
        return builder.build();
    }

    private boolean initConnection(PeerConnection newConnection, ConnectionHandler connectionHandler) {
        boolean success = connectionHandler.handleConnection(newConnection);
        if (success) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Successfully initialized newly established connection to peer: {}, handshake handler: {}", (Object)newConnection.getRemotePeer(), (Object)connectionHandler.getClass().getName());
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Failed to initialize newly established connection to peer: {}, handshake handler: {}", (Object)newConnection.getRemotePeer(), (Object)connectionHandler.getClass().getName());
        }
        return success;
    }

    private void closeQuietly(SocketChannel channel) {
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e1) {
                try {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Failed to close outgoing channel: {}. Reason: {} ({})", new Object[]{channel.getRemoteAddress(), e1.getClass().getName(), e1.getMessage()});
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void releaseBuffer(BorrowedBuffer<ByteBuffer> buffer) {
        try {
            buffer.release();
        }
        catch (Exception e) {
            LOGGER.error("Failed to release buffer", (Throwable)e);
        }
    }
}

