/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.BtException;
import java.util.Arrays;
import java.util.Objects;

public class PeerId {
    private static final int PEER_ID_LENGTH = 20;
    private final byte[] peerId;

    public static int length() {
        return 20;
    }

    public static PeerId fromBytes(byte[] bytes) {
        return new PeerId(bytes);
    }

    private PeerId(byte[] peerId) {
        Objects.requireNonNull(peerId);
        if (peerId.length != 20) {
            throw new BtException("Illegal peer ID length: " + peerId.length);
        }
        this.peerId = peerId;
    }

    public byte[] getBytes() {
        return this.peerId;
    }

    public int hashCode() {
        return Arrays.hashCode(this.peerId);
    }

    public boolean equals(Object obj) {
        if (obj == null || !PeerId.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        return obj == this || Arrays.equals(this.peerId, ((PeerId)obj).getBytes());
    }

    public String toString() {
        return Arrays.toString(this.peerId);
    }
}

