/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SharedSelector
extends Selector {
    private final Selector delegate;
    private final ReentrantReadWriteLock registrationLock;
    private volatile boolean selectInProgress;

    public SharedSelector(Selector delegate) {
        this.delegate = delegate;
        this.registrationLock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public SelectorProvider provider() {
        return this.delegate.provider();
    }

    @Override
    public Set<SelectionKey> keys() {
        return this.delegate.keys();
    }

    @Override
    public Set<SelectionKey> selectedKeys() {
        return this.delegate.selectedKeys();
    }

    @Override
    public int selectNow() throws IOException {
        this.registrationLock.writeLock().lock();
        try {
            this.selectInProgress = true;
            int n = this.delegate.selectNow();
            return n;
        }
        finally {
            this.selectInProgress = false;
            this.registrationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(long timeout) throws IOException {
        this.registrationLock.writeLock().lock();
        try {
            this.selectInProgress = true;
            int n = this.delegate.select(timeout);
            return n;
        }
        finally {
            this.selectInProgress = false;
            this.registrationLock.writeLock().unlock();
        }
    }

    @Override
    public int select() throws IOException {
        this.registrationLock.writeLock().lock();
        try {
            this.selectInProgress = true;
            int n = this.delegate.select();
            return n;
        }
        finally {
            this.selectInProgress = false;
            this.registrationLock.writeLock().unlock();
        }
    }

    @Override
    public Selector wakeup() {
        return this.delegate.wakeup();
    }

    public void wakeupAndRegister(SelectableChannel channel, int ops, Object attachment) {
        while (!this.registrationLock.readLock().tryLock()) {
            if (!this.selectInProgress) continue;
            this.delegate.wakeup();
        }
        try {
            channel.register(this.delegate, ops, attachment);
        }
        catch (ClosedChannelException e) {
            throw new RuntimeException("Failed to register channel", e);
        }
        finally {
            this.registrationLock.readLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public Optional<SelectionKey> keyFor(SelectableChannel channel) {
        return Optional.ofNullable(channel.keyFor(this.delegate));
    }
}

