/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.net.ConnectionResult;
import bt.net.ConnectionRoutine;
import bt.net.IPeerConnectionFactory;
import bt.net.Peer;
import bt.net.PeerConnectionAcceptor;
import bt.peer.IPeerCache;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelConnectionAcceptor
implements PeerConnectionAcceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketChannelConnectionAcceptor.class);
    private final Selector selector;
    private final IPeerCache peerCache;
    private final IPeerConnectionFactory connectionFactory;
    private final InetSocketAddress localAddress;
    private ServerSocketChannel serverChannel;

    public SocketChannelConnectionAcceptor(Selector selector, IPeerCache peerCache, IPeerConnectionFactory connectionFactory, InetSocketAddress localAddress) {
        this.selector = selector;
        this.peerCache = peerCache;
        this.connectionFactory = connectionFactory;
        this.localAddress = localAddress;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public NetworkInterface getNetworkInterface() {
        InetAddress address = this.localAddress.getAddress();
        try {
            return NetworkInterface.getByInetAddress(address);
        }
        catch (SocketException e) {
            throw new RuntimeException("Failed to get network interface for address: " + address, e);
        }
    }

    @Override
    public ConnectionRoutine accept() {
        SocketAddress localAddress;
        ServerSocketChannel serverChannel;
        try {
            serverChannel = this.getServerChannel();
            localAddress = serverChannel.getLocalAddress();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create incoming connection acceptor -- unexpected I/O exception happened when creating an incoming channel", e);
        }
        try {
            SocketChannel channel;
            SocketAddress remoteAddress = null;
            do {
                if ((channel = serverChannel.accept()) == null) continue;
                try {
                    remoteAddress = channel.getRemoteAddress();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to establish incoming connection", (Throwable)e);
                }
            } while (channel == null || remoteAddress == null);
            return this.getConnectionRoutine(channel, remoteAddress);
        }
        catch (ClosedChannelException e) {
            throw new RuntimeException("Incoming channel @ " + localAddress + " has been closed, will stop accepting incoming connections...");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected I/O error when listening to the incoming channel @ " + localAddress + ", will stop accepting incoming connections...", e);
        }
    }

    private ServerSocketChannel getServerChannel() throws IOException {
        if (this.serverChannel == null) {
            ServerSocketChannel _serverChannel = this.selector.provider().openServerSocketChannel();
            _serverChannel.bind(this.localAddress);
            _serverChannel.configureBlocking(true);
            this.serverChannel = _serverChannel;
            LOGGER.info("Opening server channel for incoming connections @ {}", (Object)this.localAddress);
        }
        return this.serverChannel;
    }

    private ConnectionRoutine getConnectionRoutine(final SocketChannel incomingChannel, final SocketAddress remoteAddress) {
        return new ConnectionRoutine(){

            @Override
            public SocketAddress getRemoteAddress() {
                return remoteAddress;
            }

            @Override
            public ConnectionResult establish() {
                return SocketChannelConnectionAcceptor.this.createConnection(incomingChannel, remoteAddress);
            }

            @Override
            public void cancel() {
                try {
                    incomingChannel.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close incoming channel: " + remoteAddress, (Throwable)e);
                }
            }
        };
    }

    private ConnectionResult createConnection(SocketChannel incomingChannel, SocketAddress remoteAddress) {
        try {
            Peer peer = this.peerCache.getPeerForAddress((InetSocketAddress)remoteAddress);
            return this.connectionFactory.createIncomingConnection(peer, incomingChannel);
        }
        catch (Exception e) {
            LOGGER.error("Failed to establish incoming connection from peer: " + remoteAddress, (Throwable)e);
            try {
                incomingChannel.close();
            }
            catch (IOException e1) {
                LOGGER.error("Failed to");
            }
            return ConnectionResult.failure("Unexpected error", e);
        }
    }
}

