/*
 * Decompiled with CFR 0.152.
 */
package bt.net;

import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.net.PeerConnection;
import bt.net.pipeline.ChannelHandler;
import bt.protocol.Message;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketPeerConnection
implements PeerConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketPeerConnection.class);
    private static final long WAIT_BETWEEN_READS = 100L;
    private final AtomicReference<TorrentId> torrentId = new AtomicReference();
    private final Peer remotePeer;
    private final ChannelHandler handler;
    private final AtomicLong lastActive;
    private final ReentrantLock readLock;
    private final Condition condition;

    SocketPeerConnection(Peer remotePeer, ChannelHandler handler) {
        this.remotePeer = remotePeer;
        this.handler = handler;
        this.lastActive = new AtomicLong();
        this.readLock = new ReentrantLock(true);
        this.condition = this.readLock.newCondition();
    }

    @Override
    public TorrentId setTorrentId(TorrentId torrentId) {
        return this.torrentId.getAndSet(torrentId);
    }

    @Override
    public TorrentId getTorrentId() {
        return this.torrentId.get();
    }

    @Override
    public synchronized Message readMessageNow() throws IOException {
        Message message = this.handler.receive();
        if (message != null) {
            this.updateLastActive();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Received message from peer: " + this.remotePeer + " -- " + message);
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Message readMessage(long timeout) throws IOException {
        Message message = this.readMessageNow();
        if (message == null) {
            long started = System.currentTimeMillis();
            long remaining = timeout;
            while (!this.handler.isClosed()) {
                try {
                    this.readLock.lock();
                    try {
                        this.condition.await(timeout < 100L ? timeout : 100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Unexpectedly interrupted", e);
                    }
                    remaining -= 100L;
                    message = this.readMessageNow();
                    if (message != null) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Received message from peer: " + this.remotePeer + " -- " + message + " (in " + (System.currentTimeMillis() - started) + " ms)");
                        }
                        Message message2 = message;
                        return message2;
                    }
                    if (remaining > 0L) continue;
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Failed to read message from peer: " + this.remotePeer + " (in " + (System.currentTimeMillis() - started) + " ms)");
                    }
                    Message message3 = null;
                    return message3;
                }
                finally {
                    this.readLock.unlock();
                }
            }
        }
        return message;
    }

    @Override
    public synchronized void postMessage(Message message) throws IOException {
        this.updateLastActive();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Sending message to peer: " + this.remotePeer + " -- " + message);
        }
        if (!this.handler.send(message)) {
            throw new RuntimeException("Failed to send message");
        }
    }

    private void updateLastActive() {
        this.lastActive.set(System.currentTimeMillis());
    }

    @Override
    public Peer getRemotePeer() {
        return this.remotePeer;
    }

    @Override
    public void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException e) {
            LOGGER.warn("Failed to close connection for peer: " + this.remotePeer, (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Closing connection for peer: " + this.remotePeer);
            }
            this.handler.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.handler.isClosed();
    }

    @Override
    public long getLastActive() {
        return this.lastActive.get();
    }
}

