/*
 * Decompiled with CFR 0.152.
 */
package bt.net.buffer;

import bt.net.buffer.BorrowedBuffer;
import bt.net.buffer.IBufferManager;
import bt.runtime.Config;
import com.google.inject.Inject;
import java.lang.ref.SoftReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.ReentrantLock;

public class BufferManager
implements IBufferManager {
    private ConcurrentMap<Class<?>, Deque<SoftReference<?>>> releasedBuffers;
    private final int bufferSize;

    @Inject
    public BufferManager(Config config) {
        this.bufferSize = BufferManager.getBufferSize(config.getMaxTransferBlockSize());
        this.releasedBuffers = new ConcurrentHashMap();
    }

    private static int getBufferSize(long maxTransferBlockSize) {
        if (maxTransferBlockSize > 0x3FFFFFF9L) {
            throw new IllegalArgumentException("Transfer block size is too large: " + maxTransferBlockSize);
        }
        return (int)maxTransferBlockSize * 2;
    }

    @Override
    public BorrowedBuffer<ByteBuffer> borrowByteBuffer() {
        SoftReference<?> ref;
        Deque<SoftReference<?>> deque = this.getReleasedBuffersDeque(ByteBuffer.class);
        ByteBuffer buffer = null;
        do {
            if ((ref = deque.pollLast()) == null) continue;
            buffer = (ByteBuffer)ref.get();
        } while (ref != null && buffer == null);
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(this.bufferSize);
        } else {
            buffer.clear();
        }
        return new DefaultBorrowedBuffer(this, (Buffer)buffer);
    }

    private <T extends Buffer> Deque<SoftReference<?>> getReleasedBuffersDeque(Class<T> bufferType) {
        return this.releasedBuffers.computeIfAbsent(bufferType, it -> new LinkedBlockingDeque());
    }

    private static class DefaultBorrowedBuffer<T extends Buffer>
    implements BorrowedBuffer<T> {
        private volatile T buffer;
        private final ReentrantLock lock;
        final /* synthetic */ BufferManager this$0;

        DefaultBorrowedBuffer(T buffer) {
            this.this$0 = var1_1;
            this.buffer = (Buffer)Objects.requireNonNull(buffer);
            this.lock = new ReentrantLock();
        }

        @Override
        public T lockAndGet() {
            this.lock.lock();
            return this.buffer;
        }

        @Override
        public void unlock() {
            this.lock.unlock();
        }

        @Override
        public void release() {
            this.lock.lock();
            if (this.lock.getHoldCount() > 1) {
                this.lock.unlock();
                throw new IllegalStateException("Buffer is locked and can't be released");
            }
            try {
                if (this.buffer != null) {
                    this.this$0.getReleasedBuffersDeque(ByteBuffer.class).add(new SoftReference<T>(this.buffer));
                }
            }
            finally {
                this.buffer = null;
                this.lock.unlock();
            }
        }
    }
}

