/*
 * Decompiled with CFR 0.152.
 */
package bt.net.buffer;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Buffers {
    public static boolean searchPattern(ByteBuffer buf, byte[] pattern) {
        byte b;
        if (pattern.length == 0) {
            throw new IllegalArgumentException("Empty pattern");
        }
        if (buf.remaining() < pattern.length) {
            return false;
        }
        int pos = buf.position();
        int len = pattern.length;
        int p = 31;
        int mult0 = 1;
        for (int i = 0; i < len - 1; ++i) {
            mult0 *= p;
        }
        int hash = 0;
        for (int i = 0; i < len - 1; ++i) {
            hash += pattern[i];
            hash *= p;
        }
        hash += pattern[len - 1];
        int bufhash = 0;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len - 1; ++i) {
            bytes[i] = b = buf.get();
            bufhash += b;
            bufhash *= p;
        }
        bytes[bytes.length - 1] = b = buf.get();
        bufhash += b;
        boolean found = false;
        while (true) {
            if (bufhash == hash && Arrays.equals(pattern, bytes)) {
                found = true;
                break;
            }
            if (!buf.hasRemaining()) break;
            byte next = buf.get();
            bufhash -= bytes[0] * mult0;
            bufhash *= p;
            bufhash += next;
            System.arraycopy(bytes, 1, bytes, 0, len - 1);
            bytes[len - 1] = next;
        }
        if (!found) {
            buf.position(pos);
        }
        return found;
    }
}

