/*
 * Decompiled with CFR 0.152.
 */
package bt.net.crypto;

import bt.net.BigIntegers;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

class MSEKeyPairGenerator {
    private static final BigInteger P = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563", 16);
    private static final BigInteger G = BigInteger.valueOf(2L);
    static final int PUBLIC_KEY_BYTES = 96;
    private final SecureRandom random;
    private final int privateKeySize;

    MSEKeyPairGenerator(int privateKeySize) {
        if (privateKeySize < 16 || privateKeySize > 512) {
            throw new IllegalArgumentException("Illegal key size: " + privateKeySize + "; expected 16..512 bytes");
        }
        this.random = new SecureRandom();
        this.privateKeySize = privateKeySize;
    }

    KeyPair generateKeyPair() {
        MSEPrivateKey privateKey = new MSEPrivateKey(this.privateKeySize, this.random);
        MSEPublicKey publicKey = privateKey.getPublicKey();
        return new KeyPair(publicKey, privateKey);
    }

    int getPublicKeySize() {
        return 96;
    }

    BigInteger calculateSharedSecret(BigInteger publicKey, PrivateKey privateKey) {
        if (privateKey instanceof MSEPrivateKey) {
            return ((MSEPrivateKey)privateKey).calculateSharedSecret(new MSEPublicKey(publicKey));
        }
        throw new IllegalArgumentException("Unsupported key type: " + privateKey.getClass().getName());
    }

    private static class MSEPrivateKey
    implements PrivateKey {
        private final BigInteger value;
        private volatile MSEPublicKey publicKey;
        private final Object lock;

        MSEPrivateKey(int size, SecureRandom random) {
            this.value = this.generatePrivateKey(size, random);
            this.lock = new Object();
        }

        private BigInteger generatePrivateKey(int size, SecureRandom random) {
            byte[] bytes = new byte[size];
            for (int i = 0; i < size; ++i) {
                bytes[i] = (byte)random.nextInt(256);
            }
            return BigIntegers.decodeUnsigned(ByteBuffer.wrap(bytes), size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        MSEPublicKey getPublicKey() {
            if (this.publicKey == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.publicKey == null) {
                        this.publicKey = new MSEPublicKey(G.modPow(this.value, P));
                    }
                }
            }
            return this.publicKey;
        }

        BigInteger calculateSharedSecret(MSEPublicKey publicKey) {
            return publicKey.getValue().modPow(this.value, P);
        }

        @Override
        public String getAlgorithm() {
            return "DH";
        }

        @Override
        public String getFormat() {
            return null;
        }

        @Override
        public byte[] getEncoded() {
            return null;
        }
    }

    private static class MSEPublicKey
    implements PublicKey {
        private final BigInteger value;
        private volatile byte[] encoded;
        private final Object lock;

        private MSEPublicKey(BigInteger value) {
            this.value = value;
            this.lock = new Object();
        }

        BigInteger getValue() {
            return this.value;
        }

        @Override
        public String getAlgorithm() {
            return "DH";
        }

        @Override
        public String getFormat() {
            return "MSE";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getEncoded() {
            if (this.encoded == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.encoded == null) {
                        this.encoded = BigIntegers.encodeUnsigned(this.value, 96);
                    }
                }
            }
            return this.encoded;
        }
    }
}

