/*
 * Decompiled with CFR 0.152.
 */
package bt.net.extended;

import bt.metainfo.TorrentId;
import bt.net.HandshakeHandler;
import bt.net.PeerConnection;
import bt.protocol.Handshake;
import bt.protocol.IExtendedHandshakeFactory;
import bt.protocol.extended.ExtendedHandshake;
import com.google.inject.Inject;
import java.io.IOException;

public class ExtendedProtocolHandshakeHandler
implements HandshakeHandler {
    private static final int EXTENDED_FLAG_BIT_INDEX = 43;
    private IExtendedHandshakeFactory extendedHandshakeFactory;

    @Inject
    public ExtendedProtocolHandshakeHandler(IExtendedHandshakeFactory extendedHandshakeFactory) {
        this.extendedHandshakeFactory = extendedHandshakeFactory;
    }

    @Override
    public void processIncomingHandshake(PeerConnection connection, Handshake peerHandshake) {
        ExtendedHandshake extendedHandshake = this.getHandshake(peerHandshake.getTorrentId());
        if (!extendedHandshake.getData().isEmpty()) {
            try {
                connection.postMessage(extendedHandshake);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to send extended handshake to peer: " + connection.getRemotePeer(), e);
            }
        }
    }

    @Override
    public void processOutgoingHandshake(Handshake handshake) {
        ExtendedHandshake extendedHandshake = this.getHandshake(handshake.getTorrentId());
        if (!extendedHandshake.getData().isEmpty()) {
            handshake.setReservedBit(43);
        }
    }

    private ExtendedHandshake getHandshake(TorrentId torrentId) {
        return this.extendedHandshakeFactory.getHandshake(torrentId);
    }
}

