/*
 * Decompiled with CFR 0.152.
 */
package bt.net.pipeline;

import bt.net.Peer;
import bt.net.buffer.BorrowedBuffer;
import bt.net.buffer.BufferMutator;
import bt.net.pipeline.ChannelPipeline;
import bt.protocol.Message;
import bt.protocol.handler.MessageHandler;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class ChannelPipelineBuilder {
    private final Peer peer;
    private ByteChannel channel;
    private MessageHandler<Message> protocol;
    private BorrowedBuffer<ByteBuffer> inboundBuffer;
    private BorrowedBuffer<ByteBuffer> outboundBuffer;
    private List<BufferMutator> decoders;
    private List<BufferMutator> encoders;

    ChannelPipelineBuilder(Peer peer) {
        this.peer = Objects.requireNonNull(peer);
    }

    public ChannelPipelineBuilder channel(ByteChannel channel) {
        this.channel = Objects.requireNonNull(channel);
        return this;
    }

    public ChannelPipelineBuilder protocol(MessageHandler<Message> protocol) {
        this.protocol = Objects.requireNonNull(protocol);
        return this;
    }

    public ChannelPipelineBuilder inboundBuffer(BorrowedBuffer<ByteBuffer> inboundBuffer) {
        this.inboundBuffer = Objects.requireNonNull(inboundBuffer);
        return this;
    }

    public ChannelPipelineBuilder outboundBuffer(BorrowedBuffer<ByteBuffer> outboundBuffer) {
        this.outboundBuffer = Objects.requireNonNull(outboundBuffer);
        return this;
    }

    public ChannelPipelineBuilder decoders(BufferMutator firstDecoder, BufferMutator ... otherDecoders) {
        Objects.requireNonNull(firstDecoder);
        this.decoders = this.asList(firstDecoder, otherDecoders);
        return this;
    }

    public ChannelPipelineBuilder encoders(BufferMutator firstEncoder, BufferMutator ... otherEncoders) {
        Objects.requireNonNull(firstEncoder);
        this.encoders = this.asList(firstEncoder, otherEncoders);
        return this;
    }

    private List<BufferMutator> asList(BufferMutator firstMutator, BufferMutator ... otherMutators) {
        ArrayList<BufferMutator> mutators = new ArrayList<BufferMutator>();
        mutators.add(firstMutator);
        if (otherMutators != null) {
            mutators.addAll(Arrays.asList(otherMutators));
        }
        return mutators;
    }

    public ChannelPipeline build() {
        Objects.requireNonNull(this.channel, "Missing channel");
        Objects.requireNonNull(this.protocol, "Missing protocol");
        Optional<BorrowedBuffer<ByteBuffer>> _inboundBuffer = Optional.ofNullable(this.inboundBuffer);
        Optional<BorrowedBuffer<ByteBuffer>> _outboundBuffer = Optional.ofNullable(this.outboundBuffer);
        List<BufferMutator> _decoders = this.decoders == null ? Collections.emptyList() : this.decoders;
        List<BufferMutator> _encoders = this.encoders == null ? Collections.emptyList() : this.encoders;
        return this.doBuild(this.peer, this.channel, this.protocol, _inboundBuffer, _outboundBuffer, _decoders, _encoders);
    }

    protected abstract ChannelPipeline doBuild(Peer var1, ByteChannel var2, MessageHandler<Message> var3, Optional<BorrowedBuffer<ByteBuffer>> var4, Optional<BorrowedBuffer<ByteBuffer>> var5, List<BufferMutator> var6, List<BufferMutator> var7);
}

