/*
 * Decompiled with CFR 0.152.
 */
package bt.net.pipeline;

import bt.net.Peer;
import bt.net.buffer.BorrowedBuffer;
import bt.net.buffer.BufferMutator;
import bt.net.buffer.IBufferManager;
import bt.net.pipeline.ChannelPipeline;
import bt.net.pipeline.ChannelPipelineBuilder;
import bt.net.pipeline.DefaultChannelPipeline;
import bt.net.pipeline.IChannelPipelineFactory;
import bt.protocol.Message;
import bt.protocol.handler.MessageHandler;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.util.List;
import java.util.Optional;

public class ChannelPipelineFactory
implements IChannelPipelineFactory {
    private final IBufferManager bufferManager;

    @Inject
    public ChannelPipelineFactory(IBufferManager bufferManager) {
        this.bufferManager = bufferManager;
    }

    @Override
    public ChannelPipelineBuilder buildPipeline(Peer peer) {
        return new ChannelPipelineBuilder(peer){

            @Override
            protected ChannelPipeline doBuild(Peer peer, ByteChannel channel, MessageHandler<Message> protocol, Optional<BorrowedBuffer<ByteBuffer>> inboundBuffer, Optional<BorrowedBuffer<ByteBuffer>> outboundBuffer, List<BufferMutator> decoders, List<BufferMutator> encoders) {
                BorrowedBuffer _inboundBuffer = inboundBuffer.orElseGet(ChannelPipelineFactory.this.bufferManager::borrowByteBuffer);
                BorrowedBuffer _outboundBuffer = outboundBuffer.orElseGet(ChannelPipelineFactory.this.bufferManager::borrowByteBuffer);
                return new DefaultChannelPipeline(peer, protocol, _inboundBuffer, _outboundBuffer, decoders, encoders);
            }
        };
    }
}

