/*
 * Decompiled with CFR 0.152.
 */
package bt.net.pipeline;

import bt.net.Peer;
import bt.net.buffer.BorrowedBuffer;
import bt.net.buffer.BufferMutator;
import bt.net.pipeline.ChannelHandler;
import bt.net.pipeline.ChannelHandlerContext;
import bt.net.pipeline.ChannelPipeline;
import bt.net.pipeline.MessageDeserializer;
import bt.net.pipeline.MessageSerializer;
import bt.protocol.Message;
import bt.protocol.handler.MessageHandler;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class DefaultChannelPipeline
implements ChannelPipeline {
    private final MessageDeserializer deserializer;
    private final MessageSerializer serializer;
    private final BorrowedBuffer<ByteBuffer> inboundBuffer;
    private final BorrowedBuffer<ByteBuffer> outboundBuffer;
    private final List<BufferMutator> decoders;
    private final List<BufferMutator> encoders;
    private final Queue<Message> inboundQueue;
    private int decodedDataOffset;
    private int undecodedDataOffset;
    private DefaultChannelHandlerContext context;

    public DefaultChannelPipeline(Peer peer, MessageHandler<Message> protocol, BorrowedBuffer<ByteBuffer> inboundBuffer, BorrowedBuffer<ByteBuffer> outboundBuffer, List<BufferMutator> decoders, List<BufferMutator> encoders) {
        this.deserializer = new MessageDeserializer(peer, protocol);
        this.serializer = new MessageSerializer(peer, protocol);
        this.inboundBuffer = inboundBuffer;
        this.fireDataReceived();
        this.outboundBuffer = outboundBuffer;
        this.decoders = decoders;
        this.encoders = encoders;
        this.inboundQueue = new LinkedBlockingQueue<Message>();
    }

    @Override
    public Message decode() {
        this.checkHandlerIsBound();
        return this.inboundQueue.poll();
    }

    private void fireDataReceived() {
        ByteBuffer buffer = this.inboundBuffer.lockAndGet();
        try {
            this.processInboundData(buffer);
        }
        finally {
            this.inboundBuffer.unlock();
        }
    }

    private void processInboundData(ByteBuffer buffer) {
        int undecodedDataLimit = buffer.position();
        if (this.undecodedDataOffset < undecodedDataLimit) {
            Message message;
            buffer.flip();
            this.decoders.forEach(mutator -> {
                buffer.position(this.undecodedDataOffset);
                mutator.mutate(buffer);
            });
            this.undecodedDataOffset = undecodedDataLimit;
            buffer.position(this.decodedDataOffset);
            buffer.limit(this.undecodedDataOffset);
            while ((message = this.deserializer.deserialize(buffer)) != null) {
                this.inboundQueue.add(message);
                this.decodedDataOffset = buffer.position();
            }
            buffer.clear();
            buffer.position(undecodedDataLimit);
            if (!buffer.hasRemaining()) {
                buffer.position(this.decodedDataOffset);
                buffer.compact();
                this.undecodedDataOffset -= this.decodedDataOffset;
                buffer.position(this.undecodedDataOffset);
                this.decodedDataOffset = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean encode(Message message) {
        this.checkHandlerIsBound();
        ByteBuffer buffer = this.outboundBuffer.lockAndGet();
        if (buffer == null) {
            return false;
        }
        try {
            boolean bl = this.writeMessageToBuffer(message, buffer);
            return bl;
        }
        finally {
            this.outboundBuffer.unlock();
        }
    }

    private boolean writeMessageToBuffer(Message message, ByteBuffer buffer) {
        buffer.clear();
        boolean written = this.serializer.serialize(message, buffer);
        if (written) {
            this.encoders.forEach(mutator -> {
                buffer.flip();
                mutator.mutate(buffer);
            });
            buffer.flip();
        }
        return written;
    }

    private void checkHandlerIsBound() {
        if (this.context == null) {
            throw new IllegalStateException("Channel handler is not bound");
        }
    }

    @Override
    public ChannelHandlerContext bindHandler(ChannelHandler handler) {
        if (this.context != null) {
            if (handler == this.context.handler()) {
                return this.context;
            }
            throw new IllegalStateException("Already bound to different handler");
        }
        this.context = new DefaultChannelHandlerContext(handler, this);
        return this.context;
    }

    private class DefaultChannelHandlerContext
    implements ChannelHandlerContext {
        private final ChannelHandler handler;
        private final DefaultChannelPipeline pipeline;

        DefaultChannelHandlerContext(ChannelHandler handler, DefaultChannelPipeline pipeline) {
            this.handler = handler;
            this.pipeline = pipeline;
        }

        ChannelHandler handler() {
            return this.handler;
        }

        @Override
        public ChannelPipeline pipeline() {
            return this.pipeline;
        }

        @Override
        public void fireChannelReady() {
            this.handler.read();
        }

        @Override
        public void fireChannelRegistered() {
        }

        @Override
        public void fireChannelUnregistered() {
        }

        @Override
        public void fireChannelActive() {
        }

        @Override
        public void fireChannelInactive() {
        }

        @Override
        public void fireDataReceived() {
            this.pipeline.fireDataReceived();
        }
    }
}

