/*
 * Decompiled with CFR 0.152.
 */
package bt.net.pipeline;

import bt.BtException;
import bt.net.Peer;
import bt.protocol.DecodingContext;
import bt.protocol.Message;
import bt.protocol.handler.MessageHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

class MessageDeserializer {
    private final MessageHandler<Message> protocol;
    private final Peer peer;

    public MessageDeserializer(Peer peer, MessageHandler<Message> protocol) {
        this.peer = peer;
        this.protocol = protocol;
    }

    public Message deserialize(ByteBuffer buffer) {
        int position = buffer.position();
        int limit = buffer.limit();
        Message message = null;
        DecodingContext context = new DecodingContext(this.peer);
        int consumed = this.protocol.decode(context, buffer);
        if (consumed > 0) {
            if (consumed > limit - position) {
                throw new BtException("Unexpected amount of bytes consumed: " + consumed);
            }
            buffer.position(position + consumed);
            message = Objects.requireNonNull(context.getMessage());
        }
        return message;
    }
}

