/*
 * Decompiled with CFR 0.152.
 */
package bt.net.pipeline;

import bt.net.DataReceiver;
import bt.net.buffer.BorrowedBuffer;
import bt.net.pipeline.ChannelHandler;
import bt.net.pipeline.ChannelHandlerContext;
import bt.protocol.Message;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketChannelHandler
implements ChannelHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketChannelHandler.class);
    private final SocketChannel channel;
    private final BorrowedBuffer<ByteBuffer> inboundBuffer;
    private final BorrowedBuffer<ByteBuffer> outboundBuffer;
    private final ChannelHandlerContext context;
    private final DataReceiver dataReceiver;
    private final Object inboundBufferLock;
    private final Object outboundBufferLock;
    private final AtomicBoolean shutdown;

    public SocketChannelHandler(SocketChannel channel, BorrowedBuffer<ByteBuffer> inboundBuffer, BorrowedBuffer<ByteBuffer> outboundBuffer, Function<ChannelHandler, ChannelHandlerContext> contextFactory, DataReceiver dataReceiver) {
        this.channel = channel;
        this.inboundBuffer = inboundBuffer;
        this.outboundBuffer = outboundBuffer;
        this.context = contextFactory.apply(this);
        this.dataReceiver = dataReceiver;
        this.inboundBufferLock = new Object();
        this.outboundBufferLock = new Object();
        this.shutdown = new AtomicBoolean(false);
    }

    @Override
    public boolean send(Message message) {
        boolean encoded = this.context.pipeline().encode(message);
        if (encoded) {
            this.flush();
        }
        return encoded;
    }

    @Override
    public Message receive() {
        return this.context.pipeline().decode();
    }

    @Override
    public void read() {
        try {
            this.processInboundData();
        }
        catch (IOException e) {
            this.shutdown();
            throw new RuntimeException("Unexpected I/O error", e);
        }
    }

    @Override
    public void register() {
        this.dataReceiver.registerChannel(this.channel, this.context);
        this.context.fireChannelRegistered();
    }

    @Override
    public void unregister() {
        this.dataReceiver.unregisterChannel(this.channel);
        this.context.fireChannelUnregistered();
    }

    @Override
    public void activate() {
        this.dataReceiver.activateChannel(this.channel);
        this.context.fireChannelActive();
    }

    @Override
    public void deactivate() {
        this.dataReceiver.deactivateChannel(this.channel);
        this.context.fireChannelInactive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInboundData() throws IOException {
        Object object = this.inboundBufferLock;
        synchronized (object) {
            ByteBuffer buffer = this.inboundBuffer.lockAndGet();
            try {
                int readLast;
                int readTotal = 0;
                boolean processed = false;
                while ((readLast = this.channel.read(buffer)) > 0) {
                    processed = false;
                    readTotal += readLast;
                    if (buffer.hasRemaining()) continue;
                    this.context.fireDataReceived();
                    processed = true;
                    if (buffer.hasRemaining()) continue;
                    throw new IOException("Can't receive data: insufficient space in the incoming buffer");
                }
                if (readTotal > 0 && !processed) {
                    this.context.fireDataReceived();
                }
                if (readLast == -1) {
                    throw new EOFException();
                }
            }
            finally {
                this.inboundBuffer.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.outboundBufferLock;
        synchronized (object) {
            ByteBuffer buffer = this.outboundBuffer.lockAndGet();
            try {
                while (buffer.hasRemaining() && this.channel.write(buffer) > 0) {
                }
                this.outboundBuffer.unlock();
            }
            catch (IOException e) {
                this.outboundBuffer.unlock();
                this.shutdown();
                throw new RuntimeException("Unexpected I/O error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.inboundBufferLock;
        synchronized (object) {
            Object object2 = this.outboundBufferLock;
            synchronized (object2) {
                this.shutdown();
            }
        }
    }

    private void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            try {
                this.unregister();
            }
            catch (Exception e) {
                LOGGER.error("Failed to unregister channel", (Throwable)e);
            }
            this.closeChannel();
            this.releaseBuffers();
        }
    }

    private void closeChannel() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close channel", (Throwable)e);
        }
    }

    private void releaseBuffers() {
        this.releaseBuffer(this.inboundBuffer);
        this.releaseBuffer(this.outboundBuffer);
    }

    private void releaseBuffer(BorrowedBuffer<ByteBuffer> buffer) {
        try {
            buffer.release();
        }
        catch (Exception e) {
            LOGGER.error("Failed to release buffer", (Throwable)e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.shutdown.get();
    }
}

