/*
 * Decompiled with CFR 0.152.
 */
package bt.peer;

import bt.net.InetPeer;
import bt.net.Peer;
import bt.net.PeerId;
import bt.peer.IPeerCache;
import bt.peer.PeerOptions;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class PeerCache
implements IPeerCache {
    private final ConcurrentMap<InetSocketAddress, UpdatablePeer> knownPeers = new ConcurrentHashMap<InetSocketAddress, UpdatablePeer>();
    private final ReentrantLock peerLock = new ReentrantLock();

    PeerCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer store(Peer peer) {
        this.peerLock.lock();
        try {
            UpdatablePeer newPeer = new UpdatablePeer(peer);
            UpdatablePeer existing = this.knownPeers.putIfAbsent(peer.getInetSocketAddress(), newPeer);
            if (existing != null) {
                existing.setOptions(peer.getOptions());
            }
            UpdatablePeer updatablePeer = existing == null ? newPeer : existing;
            return updatablePeer;
        }
        finally {
            this.peerLock.unlock();
        }
    }

    @Override
    public Peer getPeerForAddress(InetSocketAddress address) {
        Peer existing = (Peer)this.knownPeers.get(address);
        if (existing == null) {
            this.peerLock.lock();
            try {
                existing = (Peer)this.knownPeers.get(address);
                if (existing == null) {
                    existing = this.store(new InetPeer(address));
                }
            }
            finally {
                this.peerLock.unlock();
            }
        }
        return existing;
    }

    private static class UpdatablePeer
    implements Peer {
        private final Peer delegate;
        private volatile PeerOptions options;

        UpdatablePeer(Peer delegate) {
            this.delegate = delegate;
            this.options = delegate.getOptions();
        }

        @Override
        public InetSocketAddress getInetSocketAddress() {
            return this.delegate.getInetSocketAddress();
        }

        @Override
        public InetAddress getInetAddress() {
            return this.delegate.getInetAddress();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public Optional<PeerId> getPeerId() {
            return this.delegate.getPeerId();
        }

        @Override
        public PeerOptions getOptions() {
            return this.options;
        }

        void setOptions(PeerOptions options) {
            this.options = options;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object object) {
            return this.delegate.equals(object);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

