/*
 * Decompiled with CFR 0.152.
 */
package bt.peer;

import bt.protocol.crypto.EncryptionPolicy;

public class PeerOptions {
    private final EncryptionPolicy encryptionPolicy;

    public static PeerOptions defaultOptions() {
        return new PeerOptions(EncryptionPolicy.PREFER_PLAINTEXT);
    }

    private PeerOptions(EncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public EncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public PeerOptions withEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        return new Builder().encryptionPolicy(encryptionPolicy).build();
    }

    private static class Builder {
        private EncryptionPolicy encryptionPolicy;

        private Builder() {
        }

        public Builder encryptionPolicy(EncryptionPolicy encryptionPolicy) {
            this.encryptionPolicy = encryptionPolicy;
            return this;
        }

        public PeerOptions build() {
            return new PeerOptions(this.encryptionPolicy);
        }
    }
}

