/*
 * Decompiled with CFR 0.152.
 */
package bt.peer;

import bt.net.Peer;
import bt.peer.PeerSource;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledPeerSource
implements PeerSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledPeerSource.class);
    private final ExecutorService executor;
    private final ReentrantLock lock;
    private final AtomicReference<Future<?>> futureOptional;
    private final Queue<Peer> peers;

    public ScheduledPeerSource(ExecutorService executor) {
        this.executor = executor;
        this.lock = new ReentrantLock();
        this.futureOptional = new AtomicReference();
        this.peers = new LinkedBlockingQueue<Peer>();
    }

    @Override
    public Collection<Peer> getPeers() {
        return this.peers;
    }

    @Override
    public boolean update() {
        if (this.peers.isEmpty()) {
            this.schedulePeerCollection();
        }
        return !this.peers.isEmpty();
    }

    private void schedulePeerCollection() {
        if (this.lock.tryLock()) {
            try {
                Future<?> future;
                if (this.futureOptional.get() != null && (future = this.futureOptional.get()).isDone()) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        LOGGER.warn("Peer collection finished with exception in peer source: " + this.toString(), (Throwable)e);
                    }
                    this.futureOptional.set(null);
                }
                if (this.futureOptional.get() == null) {
                    this.futureOptional.set(this.executor.submit(() -> this.collectPeers(this.peers::add)));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected abstract void collectPeers(Consumer<Peer> var1);
}

