/*
 * Decompiled with CFR 0.152.
 */
package bt.peer;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.peer.ScheduledPeerSource;
import bt.tracker.Tracker;
import bt.tracker.TrackerResponse;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TrackerPeerSource
extends ScheduledPeerSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerPeerSource.class);
    private Tracker tracker;
    private TorrentId torrentId;
    private Duration trackerQueryInterval;
    private volatile long lastRefreshed;

    TrackerPeerSource(ExecutorService executor, Tracker tracker, TorrentId torrentId, Duration trackerQueryInterval) {
        super(executor);
        this.tracker = tracker;
        this.torrentId = torrentId;
        this.trackerQueryInterval = trackerQueryInterval;
    }

    @Override
    protected void collectPeers(Consumer<Peer> peerConsumer) {
        if (System.currentTimeMillis() - this.lastRefreshed >= this.trackerQueryInterval.toMillis()) {
            TrackerResponse response;
            try {
                response = this.tracker.request(this.torrentId).query();
            }
            finally {
                this.lastRefreshed = System.currentTimeMillis();
            }
            if (response.isSuccess()) {
                response.getPeers().forEach(peerConsumer::accept);
            } else {
                if (response.getError().isPresent()) {
                    throw new BtException("Failed to get peers for torrent", response.getError().get());
                }
                LOGGER.error("Failed to get peers for torrent -- unexpected error during interaction with the tracker; message: " + response.getErrorMessage());
            }
        }
    }

    public String toString() {
        return "TrackerPeerSource {" + this.tracker + "}";
    }
}

