/*
 * Decompiled with CFR 0.152.
 */
package bt.peer;

import bt.metainfo.Torrent;
import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.peer.PeerSource;
import bt.peer.PeerSourceFactory;
import bt.peer.TrackerPeerSource;
import bt.service.IRuntimeLifecycleBinder;
import bt.torrent.TorrentRegistry;
import bt.tracker.AnnounceKey;
import bt.tracker.ITrackerService;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

class TrackerPeerSourceFactory
implements PeerSourceFactory {
    private ITrackerService trackerService;
    private TorrentRegistry torrentRegistry;
    private Duration trackerQueryInterval;
    private ConcurrentMap<TorrentId, ConcurrentMap<AnnounceKey, TrackerPeerSource>> peerSources;
    private ExecutorService executor;
    private static final PeerSource noopSource = new PeerSource(){

        @Override
        public boolean update() {
            return false;
        }

        @Override
        public Collection<Peer> getPeers() {
            return Collections.emptyList();
        }
    };

    public TrackerPeerSourceFactory(ITrackerService trackerService, TorrentRegistry torrentRegistry, IRuntimeLifecycleBinder lifecycleBinder, Duration trackerQueryInterval) {
        this.trackerService = trackerService;
        this.torrentRegistry = torrentRegistry;
        this.trackerQueryInterval = trackerQueryInterval;
        this.peerSources = new ConcurrentHashMap<TorrentId, ConcurrentMap<AnnounceKey, TrackerPeerSource>>();
        this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
            AtomicInteger i = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "bt.peer.tracker-peer-source-" + this.i.incrementAndGet());
            }
        });
        lifecycleBinder.onShutdown("Shutdown tracker peer sources", this.executor::shutdownNow);
    }

    @Override
    public PeerSource getPeerSource(TorrentId torrentId) {
        Optional<Torrent> torrentOptional = this.torrentRegistry.getTorrent(torrentId);
        if (!torrentOptional.isPresent()) {
            return noopSource;
        }
        Torrent torrent = torrentOptional.get();
        Optional<AnnounceKey> announceKey = torrent.getAnnounceKey();
        if (!announceKey.isPresent()) {
            throw new IllegalStateException("Torrent does not have an announce key");
        }
        return this.getOrCreateTrackerPeerSource(torrentId, announceKey.get());
    }

    public PeerSource getPeerSource(TorrentId torrentId, AnnounceKey announceKey) {
        return this.getOrCreateTrackerPeerSource(torrentId, announceKey);
    }

    private TrackerPeerSource getOrCreateTrackerPeerSource(TorrentId torrentId, AnnounceKey announceKey) {
        TrackerPeerSource existing;
        ConcurrentMap<AnnounceKey, TrackerPeerSource> map = this.getOrCreateTrackerPeerSourcesMap(torrentId);
        TrackerPeerSource trackerPeerSource = (TrackerPeerSource)map.get(announceKey);
        if (trackerPeerSource == null && (existing = map.putIfAbsent(announceKey, trackerPeerSource = this.createTrackerPeerSource(torrentId, announceKey))) != null) {
            trackerPeerSource = existing;
        }
        return trackerPeerSource;
    }

    private ConcurrentMap<AnnounceKey, TrackerPeerSource> getOrCreateTrackerPeerSourcesMap(TorrentId torrentId) {
        ConcurrentMap existing;
        ConcurrentMap map = (ConcurrentHashMap)this.peerSources.get(torrentId);
        if (map == null && (existing = (ConcurrentMap)this.peerSources.putIfAbsent(torrentId, map = new ConcurrentHashMap())) != null) {
            map = existing;
        }
        return map;
    }

    private TrackerPeerSource createTrackerPeerSource(TorrentId torrentId, AnnounceKey announceKey) {
        return new TrackerPeerSource(this.executor, this.trackerService.getTracker(announceKey), torrentId, this.trackerQueryInterval);
    }
}

