/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import java.net.InetSocketAddress;
import java.util.Objects;

public class AnnounceGroup {
    private final InetSocketAddress address;
    private final int timeToLive;

    public AnnounceGroup(InetSocketAddress address, int timeToLive) {
        Objects.requireNonNull(address);
        if (!address.getAddress().isMulticastAddress()) {
            throw new IllegalArgumentException("Not a multicast address: " + address.getAddress());
        }
        if (timeToLive < 1) {
            throw new IllegalArgumentException("Illegal TTL: " + timeToLive + ". Must be greater than or equal to 1");
        }
        this.address = address;
        this.timeToLive = timeToLive;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }
}

