/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.net.InternetProtocolUtils;
import bt.peer.lan.AnnounceGroup;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnounceGroupChannel {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnounceGroupChannel.class);
    private final AnnounceGroup group;
    private final Collection<NetworkInterface> networkInterfaces;
    private final Selector selector;
    private DatagramChannel channel;
    private final AtomicBoolean shutdown;

    public AnnounceGroupChannel(AnnounceGroup group, Selector selector, Collection<NetworkInterface> networkInterfaces) {
        this.group = group;
        this.selector = selector;
        this.networkInterfaces = networkInterfaces;
        this.shutdown = new AtomicBoolean(false);
    }

    public AnnounceGroup getGroup() {
        return this.group;
    }

    public synchronized void send(ByteBuffer buffer) throws IOException {
        int written;
        if (buffer.remaining() == 0) {
            return;
        }
        do {
            written = this.getChannel().send(buffer, this.group.getAddress());
        } while (buffer.hasRemaining() && written > 0);
    }

    public synchronized SocketAddress receive(ByteBuffer buffer) throws IOException {
        if (buffer.remaining() == 0) {
            return null;
        }
        return this.getChannel().receive(buffer);
    }

    private synchronized DatagramChannel getChannel() throws IOException {
        if (this.channel == null || !this.channel.isOpen()) {
            if (this.shutdown.get()) {
                throw new IllegalStateException("Channel has been shut down");
            }
            ProtocolFamily protocolFamily = InternetProtocolUtils.getProtocolFamily(this.group.getAddress().getAddress());
            DatagramChannel _channel = this.selector.provider().openDatagramChannel(protocolFamily);
            _channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            int port = this.group.getAddress().getPort();
            if (protocolFamily == StandardProtocolFamily.INET) {
                _channel.bind(new InetSocketAddress(Inet4Address.getByName("0.0.0.0"), port));
            } else {
                _channel.bind(new InetSocketAddress(Inet6Address.getByName("[::]"), port));
            }
            int timeToLive = this.group.getTimeToLive();
            if (timeToLive != 1) {
                _channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)timeToLive);
            }
            for (NetworkInterface iface : this.networkInterfaces) {
                _channel.join(this.group.getAddress().getAddress(), iface);
            }
            _channel.configureBlocking(false);
            this.channel = _channel;
        }
        return this.channel;
    }

    public synchronized void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.closeQuietly();
        }
    }

    public synchronized void closeQuietly() {
        if (this.channel != null) {
            try {
                if (this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to close channel", (Throwable)e);
            }
            finally {
                this.channel = null;
            }
        }
    }
}

