/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.metainfo.TorrentId;
import bt.net.InternetProtocolUtils;
import bt.peer.lan.Cookie;
import bt.protocol.Protocols;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

class AnnounceMessage {
    private static final Charset ascii = Charset.forName("ASCII");
    private static final String DELIMITER = "\r\n";
    private static final String HEADER = "BT-SEARCH * HTTP/1.1\r\n";
    private static final String TERMINATOR = "\r\n\r\n";
    private final Cookie cookie;
    private final int port;
    private final Set<TorrentId> ids;

    public static int calculateMessageSize(int numberOfTorrentIds) {
        return HEADER.length() + 6 + 32 + 7 + 2 + 1 + 5 + DELIMITER.length() + 6 + 5 + DELIMITER.length() + (50 + DELIMITER.length()) * numberOfTorrentIds + 8 + Cookie.maxLength() * 2 + DELIMITER.length() + DELIMITER.length() * 2;
    }

    public static Builder builder() {
        return new Builder();
    }

    private AnnounceMessage(Cookie cookie, int port, Set<TorrentId> ids) {
        this.port = port;
        this.ids = ids;
        this.cookie = cookie;
    }

    public Cookie getCookie() {
        return this.cookie;
    }

    public int getPort() {
        return this.port;
    }

    public Set<TorrentId> getTorrentIds() {
        return this.ids;
    }

    public void writeTo(ByteBuffer buffer, InetSocketAddress recipient) {
        byte[] message = this.getMessageBytes(recipient);
        if (buffer.remaining() < message.length) {
            throw new IllegalStateException("Can't write message to buffer: insufficient space");
        }
        buffer.put(message);
    }

    private byte[] getMessageBytes(InetSocketAddress recipient) {
        StringBuilder buf = new StringBuilder();
        buf.append(HEADER);
        buf.append("Host: ");
        buf.append(InternetProtocolUtils.getLiteralIP(recipient.getAddress()));
        buf.append(":");
        buf.append(recipient.getPort());
        buf.append(DELIMITER);
        buf.append("Port: ");
        buf.append(this.port);
        buf.append(DELIMITER);
        this.ids.forEach(id -> {
            buf.append("Infohash: ");
            buf.append(Protocols.toHex(id.getBytes()));
            buf.append(DELIMITER);
        });
        buf.append("cookie: ");
        buf.append(this.cookie.toString());
        buf.append(DELIMITER);
        buf.append(DELIMITER);
        buf.append(DELIMITER);
        return buf.toString().getBytes(ascii);
    }

    public static AnnounceMessage readFrom(ByteBuffer buffer) {
        byte[] message = new byte[buffer.remaining()];
        buffer.get(message);
        return AnnounceMessage.parse(message);
    }

    private static AnnounceMessage parse(byte[] bytes) {
        Builder builder = new Builder();
        String s = new String(bytes, ascii);
        if (!s.startsWith(HEADER) && !s.endsWith(TERMINATOR)) {
            throw new IllegalStateException("Message has been truncated");
        }
        s = s.substring(HEADER.length(), s.length() - TERMINATOR.length());
        StringTokenizer tokenizer = new StringTokenizer(s, DELIMITER);
        String keyValueSeparator = ": ";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int k = token.indexOf(keyValueSeparator);
            if (k <= 0 || k >= token.length() - keyValueSeparator.length() - 1) {
                throw new IllegalStateException("Invalid token: " + token);
            }
            String key = token.substring(0, k);
            String value = token.substring(k + keyValueSeparator.length(), token.length());
            switch (key) {
                case "Host": {
                    break;
                }
                case "Port": {
                    builder.port(Integer.parseInt(value));
                    break;
                }
                case "cookie": {
                    try {
                        builder.cookie(Cookie.fromString(value));
                    }
                    catch (Exception e) {
                        builder.cookie(Cookie.unknownCookie());
                    }
                    break;
                }
                case "Infohash": {
                    builder.torrentId(TorrentId.fromBytes(Protocols.fromHex(value)));
                    break;
                }
            }
        }
        return builder.build();
    }

    public String toString() {
        return "AnnounceMessage{cookie=" + this.cookie + ", port=" + this.port + ", ids=" + this.ids + '}';
    }

    static class Builder {
        private Cookie cookie;
        private int port;
        private Set<TorrentId> ids;

        private Builder() {
        }

        public Builder cookie(Cookie cookie) {
            if (this.cookie != null) {
                throw new IllegalStateException("Cookie already set");
            }
            this.cookie = Objects.requireNonNull(cookie);
            return this;
        }

        public Builder port(int port) {
            if (this.port > 0) {
                throw new IllegalStateException("Port already set");
            }
            if (port <= 0 || port > 65535) {
                throw new IllegalArgumentException("Invalid port number: " + port);
            }
            this.port = port;
            return this;
        }

        public Builder torrentId(TorrentId id) {
            Objects.requireNonNull(id);
            if (this.ids == null) {
                this.ids = new HashSet<TorrentId>();
            }
            this.ids.add(id);
            return this;
        }

        AnnounceMessage build() {
            if (this.cookie == null) {
                throw new IllegalStateException("Can't build message: missing cookie");
            }
            if (this.ids == null) {
                throw new IllegalStateException("Can't build message: no torrents");
            }
            if (this.port == 0) {
                throw new IllegalStateException("Can't build message: missing port");
            }
            return new AnnounceMessage(this.cookie, this.port, this.ids);
        }
    }
}

