/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import java.util.Random;

public class Cookie {
    private static final int UNDEFINED = -1;
    private static final Cookie UNKNOWN_COOKIE = new UnknownCookie();
    private final int value;
    private final String valueStr;

    public static Cookie unknownCookie() {
        return UNKNOWN_COOKIE;
    }

    public static Cookie newCookie() {
        int value = new Random().nextInt() & Integer.MAX_VALUE;
        return new Cookie(value);
    }

    public static Cookie fromString(String s) throws Exception {
        return new Cookie(Integer.parseInt(s, 16));
    }

    public static boolean sameValue(Cookie c1, Cookie c2) {
        return c1.value != -1 && c2.value != -1 && c1.value == c2.value;
    }

    public static int maxLength() {
        return 8;
    }

    private Cookie() {
        this.value = -1;
        this.valueStr = null;
    }

    private Cookie(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Negative valueStr: " + value);
        }
        this.value = value;
        this.valueStr = Integer.toString(value, 16);
    }

    public String toString() {
        return this.valueStr;
    }

    private static class UnknownCookie
    extends Cookie {
        private UnknownCookie() {
        }
    }
}

