/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.metainfo.TorrentId;
import bt.peer.lan.AnnounceGroup;
import bt.peer.lan.AnnounceGroupChannel;
import bt.peer.lan.AnnounceMessage;
import bt.peer.lan.Cookie;
import bt.peer.lan.LocalServiceDiscoveryConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Set;

class LocalServiceDiscoveryAnnouncer {
    private final ByteBuffer sendBuffer;
    private final AnnounceGroupChannel channel;
    private final Cookie cookie;
    private final Set<Integer> localPorts;

    public LocalServiceDiscoveryAnnouncer(AnnounceGroupChannel channel, Cookie cookie, Set<Integer> localPorts, LocalServiceDiscoveryConfig config) {
        this.sendBuffer = LocalServiceDiscoveryAnnouncer.createBuffer(config);
        this.channel = channel;
        this.cookie = cookie;
        this.localPorts = localPorts;
    }

    private static ByteBuffer createBuffer(LocalServiceDiscoveryConfig config) {
        int maxMessageSize = AnnounceMessage.calculateMessageSize(config.getLocalServiceDiscoveryMaxTorrentsPerAnnounce());
        return ByteBuffer.allocateDirect(maxMessageSize * 2);
    }

    public AnnounceGroup getGroup() {
        return this.channel.getGroup();
    }

    public void announce(Collection<TorrentId> ids) throws IOException {
        for (Integer port : this.localPorts) {
            AnnounceMessage message = this.buildMessage(port, ids);
            this.sendBuffer.clear();
            message.writeTo(this.sendBuffer, this.channel.getGroup().getAddress());
            this.sendBuffer.flip();
            try {
                this.channel.send(this.sendBuffer);
            }
            catch (IOException e) {
                this.channel.closeQuietly();
                throw e;
            }
        }
    }

    private AnnounceMessage buildMessage(int port, Collection<TorrentId> ids) {
        AnnounceMessage.Builder builder = AnnounceMessage.builder().cookie(this.cookie).port(port);
        ids.forEach(builder::torrentId);
        return builder.build();
    }
}

