/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.peer.lan.AnnounceGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;

public class LocalServiceDiscoveryConfig {
    private Duration localServiceDiscoveryAnnounceInterval = Duration.ofSeconds(60L);
    private int localServiceDiscoveryMaxTorrentsPerAnnounce = 5;
    private Collection<AnnounceGroup> localServiceDiscoveryAnnounceGroups;

    public LocalServiceDiscoveryConfig() {
        try {
            InetAddress ip4multicast = InetAddress.getByName("239.192.152.143");
            InetAddress ip6multicast = InetAddress.getByName("[ff15::efc0:988f]");
            this.localServiceDiscoveryAnnounceGroups = Arrays.asList(new AnnounceGroup(new InetSocketAddress(ip4multicast, 6771), 1), new AnnounceGroup(new InetSocketAddress(ip6multicast, 6771), 1));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public void setLocalServiceDiscoveryAnnounceInterval(Duration localServiceDiscoveryAnnounceInterval) {
        this.localServiceDiscoveryAnnounceInterval = localServiceDiscoveryAnnounceInterval;
    }

    public Duration getLocalServiceDiscoveryAnnounceInterval() {
        return this.localServiceDiscoveryAnnounceInterval;
    }

    public void setLocalServiceDiscoveryMaxTorrentsPerAnnounce(int localServiceDiscoveryMaxTorrentsPerAnnounce) {
        this.localServiceDiscoveryMaxTorrentsPerAnnounce = localServiceDiscoveryMaxTorrentsPerAnnounce;
    }

    public int getLocalServiceDiscoveryMaxTorrentsPerAnnounce() {
        return this.localServiceDiscoveryMaxTorrentsPerAnnounce;
    }

    public void setLocalServiceDiscoveryAnnounceGroups(Collection<AnnounceGroup> localServiceDiscoveryAnnounceGroups) {
        this.localServiceDiscoveryAnnounceGroups = localServiceDiscoveryAnnounceGroups;
    }

    public Collection<AnnounceGroup> getLocalServiceDiscoveryAnnounceGroups() {
        return this.localServiceDiscoveryAnnounceGroups;
    }
}

