/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.net.InternetProtocolUtils;
import bt.net.SocketChannelConnectionAcceptor;
import bt.peer.lan.AnnounceGroup;
import bt.peer.lan.ILocalServiceDiscoveryInfo;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class LocalServiceDiscoveryInfo
implements ILocalServiceDiscoveryInfo {
    private final Set<Integer> localPorts;
    private final Collection<AnnounceGroup> compatibleGroups;
    private final Collection<NetworkInterface> networkInterfaces;

    public LocalServiceDiscoveryInfo(Set<SocketChannelConnectionAcceptor> socketAcceptors, Collection<AnnounceGroup> announceGroups) {
        this.localPorts = Collections.unmodifiableSet(this.collectLocalPorts(socketAcceptors));
        HashSet<NetworkInterface> networkInterfaces = new HashSet<NetworkInterface>();
        boolean acceptIP4 = false;
        boolean acceptIP6 = false;
        for (SocketChannelConnectionAcceptor acceptor : socketAcceptors) {
            networkInterfaces.add(acceptor.getNetworkInterface());
            InetSocketAddress address = acceptor.getLocalAddress();
            ProtocolFamily protocolFamily = InternetProtocolUtils.getProtocolFamily(address.getAddress());
            if (protocolFamily == StandardProtocolFamily.INET) {
                acceptIP4 = true;
            } else {
                acceptIP6 = true;
            }
            if (!acceptIP4 || !acceptIP6) continue;
            break;
        }
        this.compatibleGroups = Collections.unmodifiableCollection(this.collectCompatibleGroups(announceGroups, acceptIP4, acceptIP6));
        this.networkInterfaces = Collections.unmodifiableCollection(networkInterfaces);
    }

    private Set<Integer> collectLocalPorts(Set<SocketChannelConnectionAcceptor> socketAcceptors) {
        return socketAcceptors.stream().map(a -> a.getLocalAddress().getPort()).collect(Collectors.toSet());
    }

    private Collection<AnnounceGroup> collectCompatibleGroups(Collection<AnnounceGroup> groups, boolean acceptIP4, boolean acceptIP6) {
        return groups.stream().filter(group -> InternetProtocolUtils.isIP4(group.getAddress()) && acceptIP4 || InternetProtocolUtils.isIP6(group.getAddress()) && acceptIP6).collect(Collectors.toList());
    }

    @Override
    public Set<Integer> getLocalPorts() {
        return this.localPorts;
    }

    @Override
    public Collection<AnnounceGroup> getCompatibleGroups() {
        return this.compatibleGroups;
    }

    @Override
    public Collection<NetworkInterface> getNetworkInterfaces() {
        return this.networkInterfaces;
    }
}

