/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.module.PeerConnectionSelector;
import bt.module.ServiceModule;
import bt.net.PeerConnectionAcceptor;
import bt.net.SharedSelector;
import bt.net.SocketChannelConnectionAcceptor;
import bt.peer.lan.AnnounceGroup;
import bt.peer.lan.AnnounceGroupChannel;
import bt.peer.lan.Cookie;
import bt.peer.lan.ILocalServiceDiscoveryInfo;
import bt.peer.lan.ILocalServiceDiscoveryService;
import bt.peer.lan.LocalServiceDiscoveryConfig;
import bt.peer.lan.LocalServiceDiscoveryInfo;
import bt.peer.lan.LocalServiceDiscoveryPeerSourceFactory;
import bt.peer.lan.LocalServiceDiscoveryService;
import bt.service.IRuntimeLifecycleBinder;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class LocalServiceDiscoveryModule
implements Module {
    private final LocalServiceDiscoveryConfig config;

    public LocalServiceDiscoveryModule() {
        this.config = new LocalServiceDiscoveryConfig();
    }

    public LocalServiceDiscoveryModule(LocalServiceDiscoveryConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    public void configure(Binder binder) {
        binder.bind(LocalServiceDiscoveryConfig.class).toInstance((Object)this.config);
        ServiceModule.extend(binder).addPeerSourceFactory(LocalServiceDiscoveryPeerSourceFactory.class);
        binder.bind(ILocalServiceDiscoveryService.class).to(LocalServiceDiscoveryService.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    public Cookie provideLocalServiceDiscoveryCookie() {
        return Cookie.newCookie();
    }

    @Provides
    @Singleton
    public ILocalServiceDiscoveryInfo provideLocalServiceDiscoveryInfo(Set<PeerConnectionAcceptor> connectionAcceptors, LocalServiceDiscoveryConfig config) {
        Set<SocketChannelConnectionAcceptor> socketAcceptors = connectionAcceptors.stream().filter(a -> a instanceof SocketChannelConnectionAcceptor).map(a -> (SocketChannelConnectionAcceptor)a).collect(Collectors.toSet());
        return new LocalServiceDiscoveryInfo(socketAcceptors, config.getLocalServiceDiscoveryAnnounceGroups());
    }

    @Provides
    @Singleton
    public Collection<AnnounceGroupChannel> provideGroupChannels(ILocalServiceDiscoveryInfo info, @PeerConnectionSelector SharedSelector selector, IRuntimeLifecycleBinder lifecycleBinder) {
        Collection groupChannels = info.getCompatibleGroups().stream().map(g -> new AnnounceGroupChannel((AnnounceGroup)g, selector, info.getNetworkInterfaces())).collect(Collectors.toList());
        lifecycleBinder.onShutdown(() -> groupChannels.forEach(AnnounceGroupChannel::closeQuietly));
        return groupChannels;
    }
}

