/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.BufferingMap;
import bt.metainfo.TorrentId;
import bt.net.InetPeer;
import bt.net.Peer;
import bt.peer.PeerSource;
import bt.peer.PeerSourceFactory;
import bt.peer.lan.AnnounceGroupChannel;
import bt.peer.lan.AnnounceMessage;
import bt.peer.lan.Cookie;
import bt.peer.lan.LocalServiceDiscoveryConfig;
import bt.service.IRuntimeLifecycleBinder;
import bt.service.LifecycleBinding;
import com.google.inject.Inject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServiceDiscoveryPeerSourceFactory
implements PeerSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceDiscoveryPeerSourceFactory.class);
    private final ByteBuffer receiveBuffer;
    private final Collection<AnnounceGroupChannel> groupChannels;
    private final Cookie cookie;
    private final BufferingMap<TorrentId, Peer> collectedPeers;

    @Inject
    public LocalServiceDiscoveryPeerSourceFactory(Collection<AnnounceGroupChannel> groupChannels, IRuntimeLifecycleBinder lifecycleBinder, Cookie cookie, LocalServiceDiscoveryConfig config) {
        this.receiveBuffer = LocalServiceDiscoveryPeerSourceFactory.createBuffer(config);
        this.groupChannels = groupChannels;
        this.cookie = cookie;
        this.collectedPeers = new BufferingMap(HashSet::new);
        if (groupChannels.size() > 0) {
            this.schedulePeriodicPeerCollection(lifecycleBinder);
        }
    }

    private static ByteBuffer createBuffer(LocalServiceDiscoveryConfig config) {
        int maxMessageSize = AnnounceMessage.calculateMessageSize(config.getLocalServiceDiscoveryMaxTorrentsPerAnnounce());
        return ByteBuffer.allocateDirect(maxMessageSize * 2);
    }

    private void schedulePeriodicPeerCollection(IRuntimeLifecycleBinder lifecycleBinder) {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "lsd-peer-source"));
        executor.scheduleWithFixedDelay(this::collectPeers, 1L, 1L, TimeUnit.SECONDS);
        lifecycleBinder.onShutdown(LifecycleBinding.bind(executor::shutdownNow).description("Shutdown LSD peer collection").build());
    }

    private void collectPeers() {
        this.groupChannels.forEach(channel -> {
            this.receiveBuffer.clear();
            SocketAddress remoteAddress = null;
            try {
                remoteAddress = channel.receive(this.receiveBuffer);
            }
            catch (Exception e) {
                LOGGER.error("Failed to receive LSD announce", (Throwable)e);
            }
            if (remoteAddress == null) {
                return;
            }
            this.receiveBuffer.flip();
            AnnounceMessage message = null;
            try {
                message = AnnounceMessage.readFrom(this.receiveBuffer);
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse message", (Throwable)e);
            }
            if (message != null && !Cookie.sameValue(this.cookie, message.getCookie())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Received {} from {}", (Object)message, (Object)remoteAddress);
                }
                this.collectPeers(remoteAddress, message);
            }
        });
    }

    private void collectPeers(SocketAddress address, AnnounceMessage message) {
        InetPeer peer = new InetPeer(((InetSocketAddress)address).getAddress(), message.getPort());
        message.getTorrentIds().forEach(id -> this.collectedPeers.add((TorrentId)id, peer));
    }

    @Override
    public PeerSource getPeerSource(final TorrentId torrentId) {
        return new PeerSource(){
            private boolean updated;

            @Override
            public boolean update() {
                this.updated = LocalServiceDiscoveryPeerSourceFactory.this.collectedPeers.containsKey(torrentId);
                return this.updated;
            }

            @Override
            public Collection<Peer> getPeers() {
                List<Peer> peers = this.updated ? LocalServiceDiscoveryPeerSourceFactory.this.collectedPeers.removeCopy(torrentId) : Collections.emptyList();
                this.updated = false;
                return peers;
            }
        };
    }
}

