/*
 * Decompiled with CFR 0.152.
 */
package bt.peer.lan;

import bt.event.Event;
import bt.event.EventSource;
import bt.event.TorrentStartedEvent;
import bt.event.TorrentStoppedEvent;
import bt.metainfo.TorrentId;
import bt.peer.lan.AnnounceGroupChannel;
import bt.peer.lan.Cookie;
import bt.peer.lan.ILocalServiceDiscoveryInfo;
import bt.peer.lan.ILocalServiceDiscoveryService;
import bt.peer.lan.LocalServiceDiscoveryAnnouncer;
import bt.peer.lan.LocalServiceDiscoveryConfig;
import bt.service.IRuntimeLifecycleBinder;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalServiceDiscoveryService
implements ILocalServiceDiscoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalServiceDiscoveryService.class);
    private final IRuntimeLifecycleBinder lifecycleBinder;
    private final LocalServiceDiscoveryConfig config;
    private final LinkedHashSet<TorrentId> announceQueue;
    private final BlockingQueue<Event> events;
    private final Collection<LocalServiceDiscoveryAnnouncer> announcers;
    private final AtomicBoolean scheduled;

    @Inject
    public LocalServiceDiscoveryService(Cookie cookie, ILocalServiceDiscoveryInfo info, Collection<AnnounceGroupChannel> groupChannels, EventSource eventSource, IRuntimeLifecycleBinder lifecycleBinder, LocalServiceDiscoveryConfig config) {
        this.lifecycleBinder = lifecycleBinder;
        this.config = config;
        this.announceQueue = new LinkedHashSet();
        this.events = new LinkedBlockingQueue<Event>();
        this.announcers = this.createAnnouncers(groupChannels, cookie, info.getLocalPorts());
        this.scheduled = new AtomicBoolean(false);
        if (groupChannels.size() > 0) {
            eventSource.onTorrentStarted(this::onTorrentStarted);
            eventSource.onTorrentStopped(this::onTorrentStopped);
        }
    }

    private Collection<LocalServiceDiscoveryAnnouncer> createAnnouncers(Collection<AnnounceGroupChannel> groupChannels, Cookie cookie, Set<Integer> localPorts) {
        return groupChannels.stream().map(channel -> new LocalServiceDiscoveryAnnouncer((AnnounceGroupChannel)channel, cookie, localPorts, this.config)).collect(Collectors.toList());
    }

    private void schedulePeriodicAnnounce() {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "lsd-announcer"));
        long intervalMillis = this.config.getLocalServiceDiscoveryAnnounceInterval().toMillis();
        executor.scheduleWithFixedDelay(this::announce, 0L, intervalMillis, TimeUnit.MILLISECONDS);
        this.lifecycleBinder.onShutdown(executor::shutdownNow);
    }

    @Override
    public synchronized void announce() {
        if (this.announceQueue.isEmpty() && this.events.isEmpty()) {
            return;
        }
        try {
            Map<TorrentId, StatusChange> statusChanges = this.foldStartStopEvents(this.events);
            Collection<TorrentId> idsToAnnounce = this.collectNextTorrents(statusChanges);
            if (idsToAnnounce.size() > 0) {
                this.announce(idsToAnnounce);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to announce", (Throwable)e);
        }
    }

    private Map<TorrentId, StatusChange> foldStartStopEvents(BlockingQueue<Event> events) {
        Event event;
        int k = events.size();
        HashMap<TorrentId, StatusChange> statusChanges = new HashMap<TorrentId, StatusChange>(k * 2);
        while (--k >= 0 && (event = (Event)events.poll()) != null) {
            if (event instanceof TorrentStartedEvent) {
                statusChanges.put(((TorrentStartedEvent)event).getTorrentId(), StatusChange.STARTED);
                continue;
            }
            if (event instanceof TorrentStoppedEvent) {
                statusChanges.put(((TorrentStoppedEvent)event).getTorrentId(), StatusChange.STOPPED);
                continue;
            }
            LOGGER.warn("Unexpected event type: " + event.getClass().getName() + ". Skipping...");
        }
        return statusChanges;
    }

    private Collection<TorrentId> collectNextTorrents(Map<TorrentId, StatusChange> statusChanges) {
        int k = this.config.getLocalServiceDiscoveryMaxTorrentsPerAnnounce();
        ArrayList<TorrentId> ids = new ArrayList<TorrentId>(k * 2);
        Iterator iter = this.announceQueue.iterator();
        while (iter.hasNext()) {
            TorrentId id2 = (TorrentId)iter.next();
            StatusChange statusChange2 = statusChanges.get(id2);
            if (statusChange2 == null) {
                if (ids.size() >= k) continue;
                iter.remove();
                ids.add(id2);
                this.announceQueue.add(id2);
                continue;
            }
            if (statusChange2 != StatusChange.STOPPED) continue;
            iter.remove();
        }
        statusChanges.forEach((id, statusChange) -> {
            if (statusChange == StatusChange.STARTED) {
                this.announceQueue.add((TorrentId)id);
                if (ids.size() < k) {
                    ids.add((TorrentId)id);
                }
            }
        });
        return ids;
    }

    private void announce(Collection<TorrentId> ids) {
        this.announcers.forEach(a -> {
            try {
                a.announce(ids);
            }
            catch (IOException e) {
                LOGGER.error("Failed to announce to group: " + a.getGroup().getAddress(), (Throwable)e);
            }
        });
    }

    private void onTorrentStarted(TorrentStartedEvent event) {
        this.events.add(event);
        if (this.scheduled.compareAndSet(false, true)) {
            this.schedulePeriodicAnnounce();
        }
    }

    private void onTorrentStopped(TorrentStoppedEvent event) {
        this.events.add(event);
    }

    private static enum StatusChange {
        STARTED,
        STOPPED;

    }
}

