/*
 * Decompiled with CFR 0.152.
 */
package bt.peerexchange;

import bt.net.Peer;

class PeerEvent
implements Comparable<PeerEvent> {
    private Type type;
    private Peer peer;
    private long instant;

    static PeerEvent added(Peer peer) {
        return new PeerEvent(Type.ADDED, peer);
    }

    static PeerEvent dropped(Peer peer) {
        return new PeerEvent(Type.DROPPED, peer);
    }

    private PeerEvent(Type type, Peer peer) {
        this.type = type;
        this.peer = peer;
        this.instant = System.currentTimeMillis();
    }

    Type getType() {
        return this.type;
    }

    Peer getPeer() {
        return this.peer;
    }

    long getInstant() {
        return this.instant;
    }

    @Override
    public int compareTo(PeerEvent o) {
        if (this.instant == o.getInstant()) {
            return 0;
        }
        if (this.instant - o.getInstant() >= 0L) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        return "PeerEvent {type=" + (Object)((Object)this.type) + ", peer=" + this.peer + ", instant=" + this.instant + '}';
    }

    static enum Type {
        ADDED,
        DROPPED;

    }
}

