/*
 * Decompiled with CFR 0.152.
 */
package bt.peerexchange;

import bt.BtException;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEString;
import bt.net.Peer;
import bt.protocol.InvalidMessageException;
import bt.protocol.crypto.EncryptionPolicy;
import bt.protocol.extended.ExtendedMessage;
import bt.tracker.CompactPeerInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;

class PeerExchange
extends ExtendedMessage {
    private static final String ADDED_IPV4_KEY = "added";
    private static final String ADDED_IPV4_FLAGS_KEY = "added.f";
    private static final String ADDED_IPV6_KEY = "added6";
    private static final String ADDED_IPV6_FLAGS_KEY = "added6.f";
    private static final String DROPPED_IPV4_KEY = "dropped";
    private static final String DROPPED_IPV6_KEY = "dropped6";
    private static final int CRYPTO_FLAG = 1;
    private Collection<Peer> added;
    private Collection<Peer> dropped;
    private BEMap message;

    public static Builder builder() {
        return new Builder();
    }

    public static PeerExchange parse(BEMap message) {
        Map m = message.getValue();
        HashSet<Peer> added = new HashSet<Peer>();
        PeerExchange.extractPeers(m, ADDED_IPV4_KEY, ADDED_IPV4_FLAGS_KEY, CompactPeerInfo.AddressType.IPV4, added);
        PeerExchange.extractPeers(m, ADDED_IPV6_KEY, ADDED_IPV6_FLAGS_KEY, CompactPeerInfo.AddressType.IPV6, added);
        HashSet<Peer> dropped = new HashSet<Peer>();
        PeerExchange.extractPeers(m, DROPPED_IPV4_KEY, null, CompactPeerInfo.AddressType.IPV4, dropped);
        PeerExchange.extractPeers(m, DROPPED_IPV6_KEY, null, CompactPeerInfo.AddressType.IPV6, dropped);
        return new PeerExchange(added, dropped);
    }

    private static void extractPeers(Map<String, BEObject<?>> m, String peersKey, String flagsKey, CompactPeerInfo.AddressType addressType, Collection<Peer> destination) {
        if (m.containsKey(peersKey)) {
            byte[] peers = ((BEString)m.get(peersKey)).getValue();
            if (flagsKey != null && m.containsKey(flagsKey)) {
                byte[] flags = ((BEString)m.get(flagsKey)).getValue();
                PeerExchange.extractPeers(peers, flags, addressType, destination);
            } else {
                PeerExchange.extractPeers(peers, addressType, destination);
            }
        }
    }

    private static void extractPeers(byte[] peers, byte[] flags, CompactPeerInfo.AddressType addressType, Collection<Peer> destination) {
        byte[] cryptoFlags = new byte[flags.length];
        for (int i = 0; i < flags.length; ++i) {
            cryptoFlags[i] = (byte)(flags[i] & 1);
        }
        new CompactPeerInfo(peers, addressType, cryptoFlags).iterator().forEachRemaining(destination::add);
    }

    private static void extractPeers(byte[] peers, CompactPeerInfo.AddressType addressType, Collection<Peer> destination) {
        new CompactPeerInfo(peers, addressType).iterator().forEachRemaining(destination::add);
    }

    public PeerExchange(Collection<Peer> added, Collection<Peer> dropped) {
        if (added.isEmpty() && dropped.isEmpty()) {
            throw new InvalidMessageException("Can't create PEX message: no peers added/dropped");
        }
        this.added = Collections.unmodifiableCollection(added);
        this.dropped = Collections.unmodifiableCollection(dropped);
    }

    public Collection<Peer> getAdded() {
        return this.added;
    }

    public Collection<Peer> getDropped() {
        return this.dropped;
    }

    void writeTo(OutputStream out) throws IOException {
        if (this.message == null) {
            this.message = new BEMap(null, (Map)new HashMap<String, BEObject<?>>(){
                {
                    Collection inet4Peers = PeerExchange.filterByAddressType(PeerExchange.this.added, CompactPeerInfo.AddressType.IPV4);
                    Collection inet6Peers = PeerExchange.filterByAddressType(PeerExchange.this.added, CompactPeerInfo.AddressType.IPV6);
                    this.put(PeerExchange.ADDED_IPV4_KEY, PeerExchange.encodePeers(inet4Peers));
                    this.put(PeerExchange.ADDED_IPV4_FLAGS_KEY, PeerExchange.encodePeerOptions(inet4Peers));
                    this.put(PeerExchange.ADDED_IPV6_KEY, PeerExchange.encodePeers(inet6Peers));
                    this.put(PeerExchange.ADDED_IPV6_FLAGS_KEY, PeerExchange.encodePeerOptions(inet6Peers));
                    this.put(PeerExchange.DROPPED_IPV4_KEY, PeerExchange.encodePeers(PeerExchange.filterByAddressType(PeerExchange.this.dropped, CompactPeerInfo.AddressType.IPV4)));
                    this.put(PeerExchange.DROPPED_IPV6_KEY, PeerExchange.encodePeers(PeerExchange.filterByAddressType(PeerExchange.this.dropped, CompactPeerInfo.AddressType.IPV6)));
                }
            });
        }
        this.message.writeTo(out);
    }

    private static Collection<Peer> filterByAddressType(Collection<Peer> peers, CompactPeerInfo.AddressType addressType) {
        return peers.stream().filter(peer -> peer.getInetAddress().getAddress().length == addressType.length()).collect(Collectors.toList());
    }

    private static BEString encodePeers(Collection<Peer> peers) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (Peer peer : peers) {
            try {
                bos.write(peer.getInetAddress().getAddress());
                bos.write((peer.getPort() & 0xFF00) >> 8);
                bos.write(peer.getPort() & 0xFF);
            }
            catch (IOException e) {
                throw new BtException("Unexpected I/O exception", e);
            }
        }
        return new BEString(bos.toByteArray());
    }

    private static BEString encodePeerOptions(Collection<Peer> peers) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (Peer peer : peers) {
            byte options = 0;
            EncryptionPolicy encryptionPolicy = peer.getOptions().getEncryptionPolicy();
            if (encryptionPolicy == EncryptionPolicy.PREFER_ENCRYPTED || encryptionPolicy == EncryptionPolicy.REQUIRE_ENCRYPTED) {
                options = (byte)(options | 1);
            }
            bos.write(options);
        }
        return new BEString(bos.toByteArray());
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] added peers {" + this.added + "}, dropped peers {" + this.dropped + "}";
    }

    public static class Builder {
        private Collection<Peer> added = new HashSet<Peer>();
        private Collection<Peer> dropped = new HashSet<Peer>();

        private Builder() {
        }

        public Builder added(Peer peer) {
            this.added.add(peer);
            this.dropped.remove(peer);
            return this;
        }

        public Builder dropped(Peer peer) {
            this.dropped.add(peer);
            this.added.remove(peer);
            return this;
        }

        public PeerExchange build() {
            return new PeerExchange(this.added, this.dropped);
        }
    }
}

