/*
 * Decompiled with CFR 0.152.
 */
package bt.peerexchange;

import bt.bencoding.BEParser;
import bt.bencoding.model.BEMap;
import bt.peerexchange.PeerExchange;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.handler.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;

class PeerExchangeMessageHandler
implements MessageHandler<PeerExchange> {
    private final Collection<Class<? extends PeerExchange>> supportedTypes = Collections.singleton(PeerExchange.class);

    @Override
    public Collection<Class<? extends PeerExchange>> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public Class<PeerExchange> readMessageType(ByteBuffer buffer) {
        return PeerExchange.class;
    }

    @Override
    public int decode(DecodingContext context, ByteBuffer buffer) {
        byte[] payload = new byte[buffer.remaining()];
        buffer.get(payload);
        try (BEParser parser = new BEParser(payload);){
            BEMap messageContent = parser.readMap();
            PeerExchange message = PeerExchange.parse(messageContent);
            context.setMessage(message);
            int n = messageContent.getContent().length;
            return n;
        }
    }

    @Override
    public boolean encode(EncodingContext context, PeerExchange message, ByteBuffer buffer) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            message.writeTo(bos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] payload = bos.toByteArray();
        if (buffer.remaining() < payload.length) {
            return false;
        }
        buffer.put(payload);
        return true;
    }
}

