/*
 * Decompiled with CFR 0.152.
 */
package bt.peerexchange;

import bt.net.Peer;
import bt.peer.PeerSource;
import bt.peerexchange.PeerExchange;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

class PeerExchangePeerSource
implements PeerSource {
    private Queue<PeerExchange> messages = new LinkedBlockingQueue<PeerExchange>();
    private volatile Collection<Peer> peers = Collections.emptyList();
    private volatile boolean hasNewPeers;
    private final Object lock = new Object();

    PeerExchangePeerSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        if (!this.hasNewPeers) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.peers = this.collectPeers(this.messages);
            this.hasNewPeers = false;
        }
        return true;
    }

    private Collection<Peer> collectPeers(Collection<PeerExchange> messages) {
        HashSet<Peer> peers = new HashSet<Peer>();
        messages.forEach(message -> {
            message.getAdded().forEach(peers::add);
            message.getDropped().forEach(peers::remove);
        });
        return peers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMessage(PeerExchange message) {
        Object object = this.lock;
        synchronized (object) {
            this.messages.add(message);
            this.hasNewPeers = this.hasNewPeers || !message.getAdded().isEmpty();
        }
    }

    @Override
    public Collection<Peer> getPeers() {
        return this.peers;
    }
}

