/*
 * Decompiled with CFR 0.152.
 */
package bt.processor;

import bt.event.EventSink;
import bt.event.EventSource;
import bt.metainfo.IMetadataService;
import bt.module.ClientExecutor;
import bt.module.MessagingAgents;
import bt.net.IConnectionSource;
import bt.net.IMessageDispatcher;
import bt.peer.IPeerRegistry;
import bt.processor.ChainProcessor;
import bt.processor.ProcessingContext;
import bt.processor.ProcessingStage;
import bt.processor.Processor;
import bt.processor.ProcessorFactory;
import bt.processor.magnet.FetchMetadataStage;
import bt.processor.magnet.InitializeMagnetTorrentProcessingStage;
import bt.processor.magnet.MagnetContext;
import bt.processor.magnet.ProcessMagnetTorrentStage;
import bt.processor.torrent.CreateSessionStage;
import bt.processor.torrent.FetchTorrentStage;
import bt.processor.torrent.InitializeTorrentProcessingStage;
import bt.processor.torrent.ProcessTorrentStage;
import bt.processor.torrent.SeedStage;
import bt.processor.torrent.TorrentContext;
import bt.processor.torrent.TorrentContextFinalizer;
import bt.runtime.Config;
import bt.torrent.TorrentRegistry;
import bt.torrent.data.IDataWorkerFactory;
import bt.tracker.ITrackerService;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class TorrentProcessorFactory
implements ProcessorFactory {
    private TorrentRegistry torrentRegistry;
    private IDataWorkerFactory dataWorkerFactory;
    private ITrackerService trackerService;
    private ExecutorService executor;
    private IPeerRegistry peerRegistry;
    private IConnectionSource connectionSource;
    private IMessageDispatcher messageDispatcher;
    private Set<Object> messagingAgents;
    private IMetadataService metadataService;
    private EventSource eventSource;
    private EventSink eventSink;
    private Config config;
    private final Map<Class<?>, Processor<?>> processors;

    @Inject
    public TorrentProcessorFactory(TorrentRegistry torrentRegistry, IDataWorkerFactory dataWorkerFactory, ITrackerService trackerService, @ClientExecutor ExecutorService executor, IPeerRegistry peerRegistry, IConnectionSource connectionSource, IMessageDispatcher messageDispatcher, @MessagingAgents Set<Object> messagingAgents, IMetadataService metadataService, EventSource eventSource, EventSink eventSink, Config config) {
        this.torrentRegistry = torrentRegistry;
        this.dataWorkerFactory = dataWorkerFactory;
        this.trackerService = trackerService;
        this.executor = executor;
        this.peerRegistry = peerRegistry;
        this.connectionSource = connectionSource;
        this.messageDispatcher = messageDispatcher;
        this.messagingAgents = messagingAgents;
        this.metadataService = metadataService;
        this.eventSource = eventSource;
        this.eventSink = eventSink;
        this.config = config;
        this.processors = this.processors();
    }

    private Map<Class<?>, Processor<?>> processors() {
        HashMap processors = new HashMap();
        processors.put(TorrentContext.class, this.createTorrentProcessor());
        processors.put(MagnetContext.class, this.createMagnetProcessor());
        return processors;
    }

    protected ChainProcessor<TorrentContext> createTorrentProcessor() {
        SeedStage stage4 = new SeedStage(null, this.torrentRegistry);
        ProcessTorrentStage stage3 = new ProcessTorrentStage(stage4, this.torrentRegistry, this.trackerService);
        InitializeTorrentProcessingStage stage2 = new InitializeTorrentProcessingStage(stage3, this.torrentRegistry, this.dataWorkerFactory, this.eventSink, this.config);
        CreateSessionStage<TorrentContext> stage1 = new CreateSessionStage<TorrentContext>(stage2, this.torrentRegistry, this.eventSource, this.connectionSource, this.messageDispatcher, this.messagingAgents, this.config);
        FetchTorrentStage stage0 = new FetchTorrentStage((ProcessingStage<TorrentContext>)stage1);
        return new ChainProcessor<TorrentContext>(stage0, this.executor, new TorrentContextFinalizer(this.torrentRegistry));
    }

    protected ChainProcessor<MagnetContext> createMagnetProcessor() {
        SeedStage<MagnetContext> stage4 = new SeedStage<MagnetContext>(null, this.torrentRegistry);
        ProcessMagnetTorrentStage stage3 = new ProcessMagnetTorrentStage((ProcessingStage<MagnetContext>)stage4, this.torrentRegistry, this.trackerService);
        InitializeMagnetTorrentProcessingStage stage2 = new InitializeMagnetTorrentProcessingStage(stage3, this.torrentRegistry, this.dataWorkerFactory, this.eventSink, this.config);
        FetchMetadataStage stage1 = new FetchMetadataStage(stage2, this.metadataService, this.torrentRegistry, this.trackerService, this.peerRegistry, this.config);
        CreateSessionStage<MagnetContext> stage0 = new CreateSessionStage<MagnetContext>(stage1, this.torrentRegistry, this.eventSource, this.connectionSource, this.messageDispatcher, this.messagingAgents, this.config);
        return new ChainProcessor<MagnetContext>(stage0, this.executor, new TorrentContextFinalizer(this.torrentRegistry));
    }

    @Override
    public <C extends ProcessingContext> Processor<C> processor(Class<C> contextType) {
        return this.processors.get(contextType);
    }
}

