/*
 * Decompiled with CFR 0.152.
 */
package bt.processor.listener;

import bt.processor.ProcessingContext;
import bt.processor.ProcessingStage;
import bt.processor.listener.ProcessingEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public class ListenerSource<C extends ProcessingContext> {
    private Class<C> contextType;
    private Map<ProcessingEvent, Collection<BiFunction<C, ProcessingStage<C>, ProcessingStage<C>>>> listeners;

    public ListenerSource(Class<C> contextType) {
        this.contextType = contextType;
        this.listeners = new HashMap<ProcessingEvent, Collection<BiFunction<C, ProcessingStage<C>, ProcessingStage<C>>>>();
    }

    public Class<C> getContextType() {
        return this.contextType;
    }

    public void addListener(ProcessingEvent event, BiFunction<C, ProcessingStage<C>, ProcessingStage<C>> listener) {
        this.listeners.computeIfAbsent(event, it -> new ArrayList()).add(listener);
    }

    public Collection<BiFunction<C, ProcessingStage<C>, ProcessingStage<C>>> getListeners(ProcessingEvent event) {
        Objects.requireNonNull(event);
        return this.listeners.getOrDefault((Object)event, Collections.emptyList());
    }
}

