/*
 * Decompiled with CFR 0.152.
 */
package bt.processor.magnet;

import bt.metainfo.IMetadataService;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentFile;
import bt.metainfo.TorrentId;
import bt.metainfo.TorrentSource;
import bt.net.InetPeer;
import bt.net.InetPeerAddress;
import bt.peer.IPeerRegistry;
import bt.processor.ProcessingStage;
import bt.processor.TerminateOnErrorProcessingStage;
import bt.processor.listener.ProcessingEvent;
import bt.processor.magnet.MagnetContext;
import bt.runtime.Config;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentRegistry;
import bt.torrent.messaging.BitfieldCollectingConsumer;
import bt.torrent.messaging.MetadataConsumer;
import bt.tracker.AnnounceKey;
import bt.tracker.ITrackerService;
import java.time.Instant;
import java.util.List;
import java.util.Optional;

public class FetchMetadataStage
extends TerminateOnErrorProcessingStage<MagnetContext> {
    private IMetadataService metadataService;
    private TorrentRegistry torrentRegistry;
    private ITrackerService trackerService;
    private IPeerRegistry peerRegistry;
    private Config config;

    public FetchMetadataStage(ProcessingStage<MagnetContext> next, IMetadataService metadataService, TorrentRegistry torrentRegistry, ITrackerService trackerService, IPeerRegistry peerRegistry, Config config) {
        super(next);
        this.metadataService = metadataService;
        this.torrentRegistry = torrentRegistry;
        this.trackerService = trackerService;
        this.peerRegistry = peerRegistry;
        this.config = config;
    }

    @Override
    protected void doExecute(MagnetContext context) {
        TorrentId torrentId = context.getMagnetUri().getTorrentId();
        MetadataConsumer metadataConsumer = new MetadataConsumer(this.metadataService, torrentId, this.config);
        context.getRouter().registerMessagingAgent(metadataConsumer);
        BitfieldCollectingConsumer bitfieldConsumer = new BitfieldCollectingConsumer();
        context.getRouter().registerMessagingAgent(bitfieldConsumer);
        this.getDescriptor(torrentId).start();
        context.getMagnetUri().getPeerAddresses().forEach(peerAddress -> this.peerRegistry.addPeer(torrentId, new InetPeer((InetPeerAddress)peerAddress)));
        context.getMagnetUri().getTrackerUrls().forEach(trackerUrl -> this.peerRegistry.addPeerSource(torrentId, new AnnounceKey((String)trackerUrl)));
        Torrent torrent = metadataConsumer.waitForTorrent();
        torrent = this.amendTorrent(torrent, context.getMagnetUri().getDisplayName());
        context.setTorrent(torrent);
        context.setBitfieldConsumer(bitfieldConsumer);
    }

    private TorrentDescriptor getDescriptor(TorrentId torrentId) {
        return this.torrentRegistry.getDescriptor(torrentId).orElseThrow(() -> new IllegalStateException("No descriptor present for torrent ID: " + torrentId));
    }

    private Torrent amendTorrent(final Torrent delegate, final Optional<String> displayName) {
        Torrent torrent = displayName.isPresent() ? new Torrent(){

            @Override
            public TorrentSource getSource() {
                return delegate.getSource();
            }

            @Override
            public Optional<AnnounceKey> getAnnounceKey() {
                return Optional.empty();
            }

            @Override
            public TorrentId getTorrentId() {
                return delegate.getTorrentId();
            }

            @Override
            public String getName() {
                String name = delegate.getName();
                return name == null ? (String)displayName.orElse(null) : name;
            }

            @Override
            public long getChunkSize() {
                return delegate.getChunkSize();
            }

            @Override
            public Iterable<byte[]> getChunkHashes() {
                return delegate.getChunkHashes();
            }

            @Override
            public long getSize() {
                return delegate.getSize();
            }

            @Override
            public List<TorrentFile> getFiles() {
                return delegate.getFiles();
            }

            @Override
            public boolean isPrivate() {
                return delegate.isPrivate();
            }

            @Override
            public Optional<Instant> getCreationDate() {
                return delegate.getCreationDate();
            }

            @Override
            public Optional<String> getCreatedBy() {
                return delegate.getCreatedBy();
            }
        } : delegate;
        return torrent;
    }

    @Override
    public ProcessingEvent after() {
        return ProcessingEvent.TORRENT_FETCHED;
    }
}

