/*
 * Decompiled with CFR 0.152.
 */
package bt.processor.magnet;

import bt.data.Bitfield;
import bt.event.EventSink;
import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.processor.ProcessingStage;
import bt.processor.listener.ProcessingEvent;
import bt.processor.magnet.MagnetContext;
import bt.processor.torrent.InitializeTorrentProcessingStage;
import bt.runtime.Config;
import bt.torrent.BitfieldBasedStatistics;
import bt.torrent.TorrentRegistry;
import bt.torrent.data.IDataWorkerFactory;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitializeMagnetTorrentProcessingStage
extends InitializeTorrentProcessingStage<MagnetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitializeMagnetTorrentProcessingStage.class);
    private EventSink eventSink;

    public InitializeMagnetTorrentProcessingStage(ProcessingStage<MagnetContext> next, TorrentRegistry torrentRegistry, IDataWorkerFactory dataWorkerFactory, EventSink eventSink, Config config) {
        super(next, torrentRegistry, dataWorkerFactory, eventSink, config);
        this.eventSink = eventSink;
    }

    @Override
    protected void doExecute(MagnetContext context) {
        super.doExecute(context);
        TorrentId torrentId = context.getTorrentId().get();
        BitfieldBasedStatistics statistics = context.getPieceStatistics();
        HashSet peersUpdated = new HashSet();
        context.getBitfieldConsumer().getBitfields().forEach((peer, bitfieldBytes) -> {
            if (statistics.getPeerBitfield((Peer)peer).isPresent()) {
                return;
            }
            try {
                peersUpdated.add(peer);
                statistics.addBitfield((Peer)peer, new Bitfield((byte[])bitfieldBytes, statistics.getPiecesTotal()));
            }
            catch (Exception e) {
                LOGGER.warn("Error happened when processing peer's bitfield", (Throwable)e);
            }
        });
        context.getBitfieldConsumer().getHaves().forEach((peer, pieces) -> {
            try {
                peersUpdated.add(peer);
                pieces.forEach(piece -> statistics.addPiece((Peer)peer, (Integer)piece));
            }
            catch (Exception e) {
                LOGGER.warn("Error happened when processing peer's haves", (Throwable)e);
            }
        });
        peersUpdated.forEach(peer -> statistics.getPeerBitfield((Peer)peer).ifPresent(bitfield -> this.eventSink.firePeerBitfieldUpdated(torrentId, (Peer)peer, (Bitfield)bitfield)));
        context.getRouter().unregisterMessagingAgent(context.getBitfieldConsumer());
        context.setBitfieldConsumer(null);
    }

    @Override
    public ProcessingEvent after() {
        return null;
    }
}

