/*
 * Decompiled with CFR 0.152.
 */
package bt.processor.torrent;

import bt.data.Bitfield;
import bt.event.EventSource;
import bt.metainfo.TorrentId;
import bt.net.IConnectionSource;
import bt.net.IMessageDispatcher;
import bt.processor.ProcessingStage;
import bt.processor.TerminateOnErrorProcessingStage;
import bt.processor.listener.ProcessingEvent;
import bt.processor.torrent.TorrentContext;
import bt.runtime.Config;
import bt.torrent.BitfieldBasedStatistics;
import bt.torrent.DefaultTorrentSessionState;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentRegistry;
import bt.torrent.messaging.Assignments;
import bt.torrent.messaging.DefaultMessageRouter;
import bt.torrent.messaging.PeerWorkerFactory;
import bt.torrent.messaging.TorrentWorker;
import java.util.Set;
import java.util.function.Supplier;

public class CreateSessionStage<C extends TorrentContext>
extends TerminateOnErrorProcessingStage<C> {
    private TorrentRegistry torrentRegistry;
    private EventSource eventSource;
    private IConnectionSource connectionSource;
    private IMessageDispatcher messageDispatcher;
    private Set<Object> messagingAgents;
    private Config config;

    public CreateSessionStage(ProcessingStage<C> next, TorrentRegistry torrentRegistry, EventSource eventSource, IConnectionSource connectionSource, IMessageDispatcher messageDispatcher, Set<Object> messagingAgents, Config config) {
        super(next);
        this.torrentRegistry = torrentRegistry;
        this.eventSource = eventSource;
        this.connectionSource = connectionSource;
        this.messageDispatcher = messageDispatcher;
        this.messagingAgents = messagingAgents;
        this.config = config;
    }

    @Override
    protected void doExecute(C context) {
        TorrentId torrentId = ((TorrentContext)context).getTorrentId().get();
        TorrentDescriptor descriptor = this.torrentRegistry.register(torrentId);
        DefaultMessageRouter router = new DefaultMessageRouter(this.messagingAgents);
        PeerWorkerFactory peerWorkerFactory = new PeerWorkerFactory(router);
        Supplier<Bitfield> bitfieldSupplier = () -> context.getBitfield();
        Supplier<Assignments> assignmentsSupplier = () -> context.getAssignments();
        Supplier<BitfieldBasedStatistics> statisticsSupplier = () -> context.getPieceStatistics();
        TorrentWorker torrentWorker = new TorrentWorker(torrentId, this.messageDispatcher, this.connectionSource, peerWorkerFactory, bitfieldSupplier, assignmentsSupplier, statisticsSupplier, this.eventSource, this.config);
        ((TorrentContext)context).setState(new DefaultTorrentSessionState(descriptor, torrentWorker));
        ((TorrentContext)context).setRouter(router);
    }

    @Override
    public ProcessingEvent after() {
        return null;
    }
}

