/*
 * Decompiled with CFR 0.152.
 */
package bt.processor.torrent;

import bt.data.Bitfield;
import bt.event.EventSink;
import bt.metainfo.Torrent;
import bt.processor.ProcessingStage;
import bt.processor.TerminateOnErrorProcessingStage;
import bt.processor.listener.ProcessingEvent;
import bt.processor.torrent.TorrentContext;
import bt.runtime.Config;
import bt.torrent.BitfieldBasedStatistics;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentRegistry;
import bt.torrent.data.DataWorker;
import bt.torrent.data.IDataWorkerFactory;
import bt.torrent.messaging.Assignments;
import bt.torrent.messaging.BitfieldConsumer;
import bt.torrent.messaging.GenericConsumer;
import bt.torrent.messaging.IncompletePiecesValidator;
import bt.torrent.messaging.MetadataProducer;
import bt.torrent.messaging.PeerRequestConsumer;
import bt.torrent.messaging.PieceConsumer;
import bt.torrent.messaging.RequestProducer;
import bt.torrent.selector.PieceSelector;
import bt.torrent.selector.ValidatingSelector;

public class InitializeTorrentProcessingStage<C extends TorrentContext>
extends TerminateOnErrorProcessingStage<C> {
    private TorrentRegistry torrentRegistry;
    private IDataWorkerFactory dataWorkerFactory;
    private EventSink eventSink;
    private Config config;

    public InitializeTorrentProcessingStage(ProcessingStage<C> next, TorrentRegistry torrentRegistry, IDataWorkerFactory dataWorkerFactory, EventSink eventSink, Config config) {
        super(next);
        this.torrentRegistry = torrentRegistry;
        this.dataWorkerFactory = dataWorkerFactory;
        this.eventSink = eventSink;
        this.config = config;
    }

    @Override
    protected void doExecute(C context) {
        Torrent torrent = ((TorrentContext)context).getTorrent().get();
        TorrentDescriptor descriptor = this.torrentRegistry.register(torrent, ((TorrentContext)context).getStorage());
        Bitfield bitfield = descriptor.getDataDescriptor().getBitfield();
        BitfieldBasedStatistics pieceStatistics = this.createPieceStatistics(bitfield);
        PieceSelector selector = this.createSelector(((TorrentContext)context).getPieceSelector(), bitfield);
        DataWorker dataWorker = this.createDataWorker(descriptor);
        Assignments assignments = new Assignments(bitfield, selector, pieceStatistics, this.config);
        ((TorrentContext)context).getRouter().registerMessagingAgent(GenericConsumer.consumer());
        ((TorrentContext)context).getRouter().registerMessagingAgent(new BitfieldConsumer(bitfield, pieceStatistics, this.eventSink));
        ((TorrentContext)context).getRouter().registerMessagingAgent(new PieceConsumer(bitfield, dataWorker));
        ((TorrentContext)context).getRouter().registerMessagingAgent(new PeerRequestConsumer(dataWorker));
        ((TorrentContext)context).getRouter().registerMessagingAgent(new RequestProducer(descriptor.getDataDescriptor()));
        ((TorrentContext)context).getRouter().registerMessagingAgent(new MetadataProducer(() -> context.getTorrent().orElse(null), this.config));
        ((TorrentContext)context).setBitfield(bitfield);
        ((TorrentContext)context).setAssignments(assignments);
        ((TorrentContext)context).setPieceStatistics(pieceStatistics);
    }

    private BitfieldBasedStatistics createPieceStatistics(Bitfield bitfield) {
        return new BitfieldBasedStatistics(bitfield);
    }

    private PieceSelector createSelector(PieceSelector selector, Bitfield bitfield) {
        IncompletePiecesValidator validator = new IncompletePiecesValidator(bitfield);
        return new ValidatingSelector(validator, selector);
    }

    private DataWorker createDataWorker(TorrentDescriptor descriptor) {
        return this.dataWorkerFactory.createWorker(descriptor.getDataDescriptor());
    }

    @Override
    public ProcessingEvent after() {
        return null;
    }
}

