/*
 * Decompiled with CFR 0.152.
 */
package bt.processor.torrent;

import bt.metainfo.Torrent;
import bt.metainfo.TorrentId;
import bt.processor.ProcessingStage;
import bt.processor.TerminateOnErrorProcessingStage;
import bt.processor.listener.ProcessingEvent;
import bt.processor.torrent.TorrentContext;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentRegistry;
import bt.torrent.TrackerAnnouncer;
import bt.tracker.AnnounceKey;
import bt.tracker.ITrackerService;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTorrentStage<C extends TorrentContext>
extends TerminateOnErrorProcessingStage<C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTorrentStage.class);
    private TorrentRegistry torrentRegistry;
    private ITrackerService trackerService;

    public ProcessTorrentStage(ProcessingStage<C> next, TorrentRegistry torrentRegistry, ITrackerService trackerService) {
        super(next);
        this.torrentRegistry = torrentRegistry;
        this.trackerService = trackerService;
    }

    @Override
    protected void doExecute(C context) {
        TorrentDescriptor descriptor = this.getDescriptor(((TorrentContext)context).getTorrentId().get());
        Torrent torrent = ((TorrentContext)context).getTorrent().get();
        Optional<AnnounceKey> announceKey = torrent.getAnnounceKey();
        if (announceKey.isPresent()) {
            TrackerAnnouncer announcer = new TrackerAnnouncer(this.trackerService, torrent, announceKey.get(), ((TorrentContext)context).getState().get());
            ((TorrentContext)context).setAnnouncer(announcer);
        }
        descriptor.start();
        this.start(context);
        while (descriptor.isActive()) {
            try {
                Thread.sleep(1000L);
                if (((TorrentContext)context).getState().get().getPiecesRemaining() != 0) continue;
                this.complete(context);
                break;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unexpectedly interrupted", e);
            }
        }
    }

    private void start(C context) {
        try {
            this.onStarted(context);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
    }

    protected void onStarted(C context) {
        ((TorrentContext)context).getAnnouncer().ifPresent(TrackerAnnouncer::start);
    }

    private void complete(C context) {
        try {
            ((TorrentContext)context).getTorrentId().ifPresent(torrentId -> this.getDescriptor((TorrentId)torrentId).complete());
            this.onCompleted(context);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error", (Throwable)e);
        }
    }

    protected void onCompleted(C context) {
        ((TorrentContext)context).getAnnouncer().ifPresent(TrackerAnnouncer::complete);
    }

    private TorrentDescriptor getDescriptor(TorrentId torrentId) {
        return this.torrentRegistry.getDescriptor(torrentId).orElseThrow(() -> new IllegalStateException("No descriptor present for torrent ID: " + torrentId));
    }

    @Override
    public ProcessingEvent after() {
        return ProcessingEvent.DOWNLOAD_COMPLETE;
    }
}

